/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.td.parser.visitor;

import com.huawei.hwclouds.migration.td.nodes.ColumnPartitionDefinitionItem;
import com.huawei.hwclouds.migration.td.nodes.CreateTable;
import com.huawei.hwclouds.migration.td.nodes.CreateTableAsClause;
import com.huawei.hwclouds.migration.td.nodes.CtasColumnDefinition;
import com.huawei.hwclouds.migration.td.nodes.Index;
import com.huawei.hwclouds.migration.td.nodes.IndexItem;
import com.huawei.hwclouds.migration.td.nodes.PrimaryIndexColumn;
import com.huawei.hwclouds.migration.td.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.td.nodes.TableSpecification;
import com.huawei.hwclouds.migration.td.parser.TeradataParser;
import com.huawei.hwclouds.migration.td.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.td.parser.visitor.ColumnPartitionDefinitionItemVisitor;
import com.huawei.hwclouds.migration.td.parser.visitor.CreateTableAsClauseVisitor;
import com.huawei.hwclouds.migration.td.parser.visitor.CtasColumnDefinitionVisitor;
import com.huawei.hwclouds.migration.td.parser.visitor.IndexVisitor;
import com.huawei.hwclouds.migration.td.parser.visitor.TableKindVisitor;
import com.huawei.hwclouds.migration.td.parser.visitor.TableSpecificationVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;

public class CreateTableVisitor
extends AbstractVisitor<CreateTable> {
    private CreateTable createTable = new CreateTable();

    @Override
    protected CreateTable defaultResult() {
        return this.createTable;
    }

    @Override
    public CreateTable visitCreateColumnTable(TeradataParser.CreateColumnTableContext ctx) {
        if (ctx.tableKind() != null) {
            this.createTable.setTableKind(new TableKindVisitor().visitTableKind(ctx.tableKind()));
        }
        if (ctx.tableSpecification() != null) {
            this.createTable.setTableSpecification((TableSpecification)new TableSpecificationVisitor().visit((ParseTree)ctx.tableSpecification()));
        }
        if (ctx.columnPartitionDefinition() != null) {
            SqlNodeList<ColumnPartitionDefinitionItem> columnPartitionDefinitionItemSqlNodeList = new SqlNodeList<ColumnPartitionDefinitionItem>();
            List<TeradataParser.ColumnPartitionDefinitionItemContext> columnPartitionDefinition = ctx.columnPartitionDefinition().columnPartitionDefinitionItem();
            for (int i = 0; i < columnPartitionDefinition.size(); ++i) {
                ColumnPartitionDefinitionItem columnItem = (ColumnPartitionDefinitionItem)new ColumnPartitionDefinitionItemVisitor().visit((ParseTree)columnPartitionDefinition.get(i));
                columnPartitionDefinitionItemSqlNodeList.addNode(columnItem);
                if (columnItem.getTableConstraint() == null || !"PRIMARY KEY".equalsIgnoreCase(columnItem.getTableConstraint().getConstraintType())) continue;
                this.createTable.setPrimaryKeyList(columnItem.getTableConstraint().getColumnList());
            }
            this.createTable.setColumnPartitionDefinitionItemSqlNodeList(columnPartitionDefinitionItemSqlNodeList);
        }
        if (ctx.index() != null) {
            this.createTable.setIndex((Index)new IndexVisitor().visit((ParseTree)ctx.index()));
            for (IndexItem indexItem : this.createTable.getIndex().getIndexItemSqlNodeList().getNodes()) {
                if (indexItem.getPrimary() != null) {
                    List<String> primaryIndexList = indexItem.getPrimaryIndexColumnSqlNodeList().getNodes().stream().map(PrimaryIndexColumn::getIndexColId).collect(Collectors.toList());
                    if (this.createTable.getPrimaryKeyList() != null && !this.createTable.getPrimaryKeyList().isEmpty()) {
                        primaryIndexList.retainAll(this.createTable.getPrimaryKeyList());
                    }
                    this.createTable.setPrimaryIndexList(primaryIndexList);
                    continue;
                }
                if (indexItem.getPartitionByClause() == null) continue;
                this.createTable.setPartitionByClause(indexItem.getPartitionByClause());
            }
        }
        if (ctx.tablePreservation() != null) {
            this.createTable.setTablePreservation(ctx.tablePreservation().tablePreservationType.getText());
        }
        return this.defaultResult();
    }

    @Override
    public CreateTable visitCreateAsTable(TeradataParser.CreateAsTableContext ctx) {
        if (ctx.tableKind() != null) {
            this.createTable.setTableKind(new TableKindVisitor().visitTableKind(ctx.tableKind()));
        }
        if (ctx.tableSpecification() != null) {
            this.createTable.setTableSpecification((TableSpecification)new TableSpecificationVisitor().visit((ParseTree)ctx.tableSpecification()));
        }
        if (ctx.ctasColumnDefinition() != null) {
            ArrayList<CtasColumnDefinition> ctasColumnDefinitionList = new ArrayList<CtasColumnDefinition>();
            for (TeradataParser.CtasColumnDefinitionContext ctasColumnDefinitionContext : ctx.ctasColumnDefinition()) {
                CtasColumnDefinition ctasColumnDefinition = (CtasColumnDefinition)new CtasColumnDefinitionVisitor().visit((ParseTree)ctasColumnDefinitionContext);
                ctasColumnDefinitionList.add(ctasColumnDefinition);
                if (ctasColumnDefinition.getTableConstraint() == null || !"PRIMARY KEY".equalsIgnoreCase(ctasColumnDefinition.getTableConstraint().getConstraintType())) continue;
                this.createTable.setPrimaryKeyList(ctasColumnDefinition.getTableConstraint().getColumnList());
            }
        }
        if (ctx.asClause() != null) {
            this.createTable.setCreateTableAsClause((CreateTableAsClause)new CreateTableAsClauseVisitor().visit((ParseTree)ctx.asClause()));
        }
        if (ctx.index() != null) {
            this.createTable.setIndex((Index)new IndexVisitor().visit((ParseTree)ctx.index()));
            for (IndexItem indexItem : this.createTable.getIndex().getIndexItemSqlNodeList().getNodes()) {
                if (indexItem.getPrimary() == null) continue;
                List<String> primaryIndexList = indexItem.getPrimaryIndexColumnSqlNodeList().getNodes().stream().map(PrimaryIndexColumn::getIndexColId).collect(Collectors.toList());
                if (this.createTable.getPrimaryKeyList() != null && !this.createTable.getPrimaryKeyList().isEmpty()) {
                    primaryIndexList.retainAll(this.createTable.getPrimaryKeyList());
                }
                this.createTable.setPrimaryIndexList(primaryIndexList);
            }
        }
        if (ctx.tablePreservation() != null) {
            this.createTable.setTablePreservation(ctx.tablePreservation().tablePreservationType.getText());
        }
        return this.defaultResult();
    }
}

