/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.td.parser.visitor;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.migration.td.nodes.DiagnosticAssignment;
import com.huawei.hwclouds.migration.td.nodes.DiagnosticStatement;
import com.huawei.hwclouds.migration.td.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.td.parser.TeradataParser;
import com.huawei.hwclouds.migration.td.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.td.parser.visitor.DiagnosticAssignmentVisitor;
import org.antlr.v4.runtime.tree.ParseTree;

public class DiagnosticStatementVisitor
extends AbstractVisitor<DiagnosticStatement> {
    private final DiagnosticStatement result = new DiagnosticStatement();

    @Override
    protected DiagnosticStatement defaultResult() {
        return this.result;
    }

    @Override
    public DiagnosticStatement visitDiagnosticStatement(TeradataParser.DiagnosticStatementContext ctx) {
        if (ctx.SIGNAL() != null) {
            throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "signal statement");
        }
        if (ctx.RESIGNAL() != null) {
            throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "resignal statement");
        }
        if (ctx.conditionNumber() != null) {
            this.result.setConditionNumber(ctx.conditionNumber().getText());
        }
        if (ctx.diagnosticAssignment() != null) {
            SqlNodeList<DiagnosticAssignment> assignmentList = new SqlNodeList<DiagnosticAssignment>();
            ctx.diagnosticAssignment().forEach(assignmentContext -> assignmentList.addNode((DiagnosticAssignment)new DiagnosticAssignmentVisitor().visit((ParseTree)assignmentContext)));
            this.result.setAssignmentList(assignmentList);
        }
        return this.defaultResult();
    }
}

