/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.td.parser.visitor;

import com.huawei.hwclouds.migration.td.nodes.Expression;
import com.huawei.hwclouds.migration.td.nodes.Predicate;
import com.huawei.hwclouds.migration.td.nodes.QueryExpr;
import com.huawei.hwclouds.migration.td.nodes.WithModifier;
import com.huawei.hwclouds.migration.td.parser.TeradataParser;
import com.huawei.hwclouds.migration.td.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.td.parser.visitor.PredicateVisitor;
import com.huawei.hwclouds.migration.td.parser.visitor.QueryExprVisitor;
import com.huawei.hwclouds.migration.td.parser.visitor.WithModifierVisitor;
import org.antlr.v4.runtime.tree.ParseTree;

public class ExpressionVisitor
extends AbstractVisitor<Expression> {
    Expression result = new Expression();

    @Override
    protected Expression defaultResult() {
        return this.result;
    }

    @Override
    public Expression visitPredicateExpression(TeradataParser.PredicateExpressionContext ctx) {
        if (ctx.predicate() != null) {
            this.result.setPredicate((Predicate)new PredicateVisitor().visit((ParseTree)ctx.predicate()));
        }
        return this.result;
    }

    @Override
    public Expression visitLogicalExpression(TeradataParser.LogicalExpressionContext ctx) {
        this.result.setExpressionBefore((Expression)new ExpressionVisitor().visit((ParseTree)ctx.expression(0)));
        this.result.setLogicalOperator(ctx.logicalOperator().getText());
        this.result.setExpressionAfter((Expression)new ExpressionVisitor().visit((ParseTree)ctx.expression(1)));
        return this.result;
    }

    @Override
    public Expression visitExistsExpression(TeradataParser.ExistsExpressionContext ctx) {
        if (ctx.NOT() != null || ctx.BIT_XOR_OP() != null) {
            this.result.setNot(true);
            String symbol = ctx.NOT() != null ? ctx.NOT().getText() : ctx.BIT_XOR_OP().getText();
            this.result.setNotSymbol(symbol);
        }
        if (ctx.withModifier() != null) {
            this.result.setWithModifier((WithModifier)new WithModifierVisitor().visit((ParseTree)ctx.withModifier()));
        }
        this.result.setQueryExpr((QueryExpr)new QueryExprVisitor().visit((ParseTree)ctx.queryExpr()));
        return this.result;
    }

    @Override
    public Expression visitBracketExpression(TeradataParser.BracketExpressionContext ctx) {
        this.result.setBracket(true);
        this.result.setExpression((Expression)new ExpressionVisitor().visit((ParseTree)ctx.expression()));
        return this.result;
    }
}

