/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.td.parser.visitor;

import com.huawei.hwclouds.migration.td.nodes.ExpressionAtom;
import com.huawei.hwclouds.migration.td.nodes.Predicate;
import com.huawei.hwclouds.migration.td.nodes.PredicateCollection;
import com.huawei.hwclouds.migration.td.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.td.parser.TeradataParser;
import com.huawei.hwclouds.migration.td.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.td.parser.visitor.ExpressionAtomVisitor;
import com.huawei.hwclouds.migration.td.parser.visitor.PredicateCollectionVisitor;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class PredicateVisitor
extends AbstractVisitor<Predicate> {
    Predicate result = new Predicate();

    @Override
    protected Predicate defaultResult() {
        return this.result;
    }

    @Override
    public Predicate visitExpressionAtomPredicate(TeradataParser.ExpressionAtomPredicateContext ctx) {
        if (ctx.expressionAtom() != null) {
            this.result.setExpressionAtom((ExpressionAtom)new ExpressionAtomVisitor().visit((ParseTree)ctx.expressionAtom()));
        }
        return this.result;
    }

    @Override
    public Predicate visitBinaryComparisonPredicate(TeradataParser.BinaryComparisonPredicateContext ctx) {
        this.result.setPredicateBefore((Predicate)new PredicateVisitor().visit((ParseTree)ctx.predicate(0)));
        this.result.setComparisonOperator(ctx.comparisonOperator().getText());
        this.result.setPredicateAfter((Predicate)new PredicateVisitor().visit((ParseTree)ctx.predicate(1)));
        return this.result;
    }

    @Override
    public Predicate visitIsNullComparisonPredicate(TeradataParser.IsNullComparisonPredicateContext ctx) {
        this.result.setSubPredicate((Predicate)new PredicateVisitor().visit((ParseTree)ctx.predicate()));
        if (ctx.NOT() != null) {
            this.result.setNotNull(true);
        } else if (ctx.NULL() != null) {
            this.result.setNull(true);
        }
        return this.result;
    }

    @Override
    public Predicate visitBracketPredicate(TeradataParser.BracketPredicateContext ctx) {
        if (ctx.op != null) {
            this.result.setOp(ctx.op.getText());
        }
        this.result.setSubPredicate((Predicate)new PredicateVisitor().visit((ParseTree)ctx.predicate()));
        this.result.setBracket(true);
        return this.result;
    }

    @Override
    public Predicate visitCollectionComparisonPredicate(TeradataParser.CollectionComparisonPredicateContext ctx) {
        this.result.setPredicateBefore((Predicate)new PredicateVisitor().visit((ParseTree)ctx.predicate()));
        this.result.setComparisonOperator(PredicateVisitor.getText(ctx.collectionComparisonOperator(), 1));
        this.result.setPredicateCollection((PredicateCollection)new PredicateCollectionVisitor().visit((ParseTree)ctx.predicateCollection()));
        return this.result;
    }

    @Override
    public Predicate visitCasespecificPredicate(TeradataParser.CasespecificPredicateContext ctx) {
        this.result.setSubPredicate((Predicate)new PredicateVisitor().visit((ParseTree)ctx.predicate()));
        return this.result;
    }

    @Override
    public Predicate visitBetweenPredicate(TeradataParser.BetweenPredicateContext ctx) {
        if (ctx.NOT() != null || ctx.BIT_XOR_OP() != null) {
            this.result.setNot(true);
            String symbol = ctx.NOT() != null ? ctx.NOT().getText() : ctx.BIT_XOR_OP().getText();
            this.result.setNotSymbol(symbol);
        }
        SqlNodeList<Predicate> predicateSqlNodeList = new SqlNodeList<Predicate>();
        ctx.predicate().forEach(predicateContext -> {
            Predicate predicate = (Predicate)new PredicateVisitor().visit((ParseTree)predicateContext);
            predicateSqlNodeList.addNode(predicate);
        });
        this.result.setSubPredicateSqlNodeList(predicateSqlNodeList);
        return this.result;
    }

    public static String getText(ParserRuleContext context, int deep) {
        StringBuilder textBuilder = new StringBuilder();
        PredicateVisitor.forEachChildText(textBuilder, context, deep);
        return textBuilder.toString();
    }

    private static void forEachChildText(StringBuilder textBuilder, ParserRuleContext context, int deep) {
        if (context == null) {
            return;
        }
        if (deep <= 0 || context.getChildCount() <= 1) {
            textBuilder.append(context.getText());
            return;
        }
        for (int i = 0; i < context.getChildCount(); ++i) {
            if (context.getChild(i) instanceof ParserRuleContext) {
                PredicateVisitor.forEachChildText(textBuilder, (ParserRuleContext)context.getChild(i), deep - 1);
            } else {
                textBuilder.append(context.getChild(i).getText());
            }
            if (i == context.getChildCount() - 1) continue;
            textBuilder.append(" ");
        }
    }
}

