/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.td.parser.visitor;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.migration.td.nodes.ColumnPartitionDefinitionItem;
import com.huawei.hwclouds.migration.td.nodes.ExprSpec;
import com.huawei.hwclouds.migration.td.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.td.nodes.TableFunctionReference;
import com.huawei.hwclouds.migration.td.parser.TeradataParser;
import com.huawei.hwclouds.migration.td.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.td.parser.visitor.ColumnPartitionDefinitionItemVisitor;
import com.huawei.hwclouds.migration.td.parser.visitor.ExprSpecVisitor;
import org.antlr.v4.runtime.tree.ParseTree;

public class TableFunctionReferenceVisitor
extends AbstractVisitor<TableFunctionReference> {
    private final TableFunctionReference result = new TableFunctionReference();

    @Override
    protected TableFunctionReference defaultResult() {
        return this.result;
    }

    @Override
    public TableFunctionReference visitTableFunctionReference(TeradataParser.TableFunctionReferenceContext ctx) {
        if (ctx.unnestTableFunction() != null) {
            throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "UNNEST");
        }
        this.result.setFunctionName(ctx.udtTableFunction().functionName.getText());
        if (ctx.udtTableFunction().exprSpec() != null) {
            this.result.setExprSpec((ExprSpec)new ExprSpecVisitor().visit((ParseTree)ctx.udtTableFunction().exprSpec()));
        }
        if (ctx.udtTableFunction().tableReferenceReturnsClause() != null && ctx.udtTableFunction().tableReferenceReturnsClause().columnPartitionDefinitionItem() != null) {
            SqlNodeList<ColumnPartitionDefinitionItem> columnList = new SqlNodeList<ColumnPartitionDefinitionItem>();
            ctx.udtTableFunction().tableReferenceReturnsClause().columnPartitionDefinitionItem().forEach(column -> columnList.addNode((ColumnPartitionDefinitionItem)new ColumnPartitionDefinitionItemVisitor().visit((ParseTree)column)));
            this.result.setColumnList(columnList);
        }
        if (ctx.AS() != null) {
            this.result.setAs(ctx.AS().getText());
        }
        if (ctx.aliasName() != null) {
            this.result.setAliasName(ctx.aliasName().getText());
        }
        return this.defaultResult();
    }
}

