/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.td.unparser;

import com.huawei.hwclouds.migration.td.UnParser;
import com.huawei.hwclouds.migration.td.UnParserAnnotation;
import com.huawei.hwclouds.migration.td.UnParserContext;
import com.huawei.hwclouds.migration.td.nodes.CollectStatistics;
import com.huawei.hwclouds.migration.td.nodes.StatsTargetSpec;
import com.huawei.hwclouds.migration.td.util.SqlDialect;
import com.huawei.hwclouds.migration.td.util.SqlString;
import com.huawei.hwclouds.migration.td.writer.SqlWriter;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=CollectStatistics.class)
public class CollectStatisticsUnParser
implements UnParser<CollectStatistics> {
    @Override
    public void unParse(CollectStatistics sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("ANALYZE ");
        sqlNode.getCollectionSource().unParse(writer, context);
        if (!sqlNode.getStatsTargetSpecSqlNodeList().getNodes().isEmpty()) {
            List<StatsTargetSpec> nodes = sqlNode.getStatsTargetSpecSqlNodeList().getNodes();
            if (nodes.size() > 1) {
                writer.append("( ");
                for (int i = 0; i < nodes.size(); ++i) {
                    StatsTargetSpec node = nodes.get(i);
                    node.unParse(writer, context);
                    if (i >= nodes.size() - 1) continue;
                    writer.append(", ");
                }
                writer.append(" )");
                SqlString sqlString = writer.toSqlString();
                String s = CollectStatisticsUnParser.flattenNestedParentheses(sqlString.toString());
                writer.clear();
                writer.append(s);
            } else {
                nodes.get(0).unParse(writer, context);
            }
        }
    }

    public static String flattenNestedParentheses(String s) {
        String pattern = "(ANALYZE\\s+\\w+\\s*\\()(.*)\\)";
        Pattern compiledPattern = Pattern.compile(pattern);
        Matcher matcher = compiledPattern.matcher(s);
        if (matcher.matches()) {
            String prefix = matcher.group(1);
            String content = matcher.group(2);
            String cleanedContent = content.replaceAll("[()]", "");
            cleanedContent = cleanedContent.replaceAll("\\s+", " ").trim();
            return prefix + cleanedContent + ")";
        }
        return s;
    }
}

