/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.td.unparser;

import com.huawei.hwclouds.migration.td.UnParser;
import com.huawei.hwclouds.migration.td.UnParserAnnotation;
import com.huawei.hwclouds.migration.td.UnParserContext;
import com.huawei.hwclouds.migration.td.nodes.CompoundStatement;
import com.huawei.hwclouds.migration.td.nodes.CreateProcedure;
import com.huawei.hwclouds.migration.td.nodes.SqlMultiStatementRequest;
import com.huawei.hwclouds.migration.td.util.SqlDialect;
import com.huawei.hwclouds.migration.td.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=CreateProcedure.class)
public class CreateProcedureUnParser
implements UnParser<CreateProcedure> {
    @Override
    public void unParse(CreateProcedure sqlNode, SqlWriter writer, UnParserContext context) {
        boolean haveBegin;
        writer.append("CREATE").writeSpace();
        if (sqlNode.isReplace()) {
            writer.append("OR REPLACE").writeSpace();
        }
        writer.append("PROCEDURE").writeSpace().append(sqlNode.getProcedureName());
        writer.append("(");
        if (sqlNode.getParameterSpecificationList() != null) {
            sqlNode.getParameterSpecificationList().unParse(writer, context);
        }
        writer.append(")").newLine();
        if (sqlNode.getNumberOfSets() != null) {
            writer.append("ROWS").writeSpace().append(sqlNode.getNumberOfSets()).newLine();
        }
        if (sqlNode.getPrivilegeOption() != null) {
            boolean notSupport;
            boolean bl = notSupport = !sqlNode.getPrivilegeOption().equalsIgnoreCase("INVOKER") && !sqlNode.getPrivilegeOption().equalsIgnoreCase("DEFINER");
            if (notSupport) {
                writer.append("/* ");
            }
            writer.append("SECURITY").writeSpace().append(sqlNode.getPrivilegeOption());
            if (notSupport) {
                writer.append(" */");
            }
            writer.newLine();
        }
        writer.append("AS");
        boolean bl = haveBegin = sqlNode.getStatement().getStatement() instanceof CompoundStatement || sqlNode.getStatement().getStatement() instanceof SqlMultiStatementRequest;
        if (!haveBegin) {
            writer.writeSpace().append("BEGIN");
        }
        writer.newLine();
        sqlNode.getStatement().unParse(writer, context);
        if (!haveBegin) {
            writer.newLine().append("END");
        }
    }
}

