/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.td.unparser;

import com.huawei.hwclouds.migration.td.UnParser;
import com.huawei.hwclouds.migration.td.UnParserAnnotation;
import com.huawei.hwclouds.migration.td.UnParserContext;
import com.huawei.hwclouds.migration.td.nodes.CreateSqlFunction;
import com.huawei.hwclouds.migration.td.nodes.FunctionAttribute;
import com.huawei.hwclouds.migration.td.nodes.ParameterSpecification;
import com.huawei.hwclouds.migration.td.util.SqlDialect;
import com.huawei.hwclouds.migration.td.writer.SqlWriter;
import java.util.List;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=CreateSqlFunction.class)
public class CreateSqlFunctionUnParser
implements UnParser<CreateSqlFunction> {
    @Override
    public void unParse(CreateSqlFunction sqlNode, SqlWriter writer, UnParserContext context) {
        List<FunctionAttribute> functionAttributes;
        List<ParameterSpecification> nodes;
        writer.append("CREATE FUNCTION ").append(sqlNode.getFunctionName()).append("( ");
        if (sqlNode.getParameterSpecificationSqlNodeList() != null && !(nodes = sqlNode.getParameterSpecificationSqlNodeList().getNodes()).isEmpty()) {
            for (int i = 0; i < nodes.size(); ++i) {
                nodes.get(i).unParse(writer, context);
                if (i >= nodes.size() - 1) continue;
                writer.append(", ");
            }
        }
        writer.append(") ");
        writer.newLine();
        writer.append("RETURNS ");
        sqlNode.getDataType().unParse(writer, context);
        writer.writeSpace();
        writer.newLine();
        this.processLanguage(sqlNode, writer, context);
        if (sqlNode.getFunctionAttribute() != null && (functionAttributes = sqlNode.getFunctionAttribute().getNodes()) != null) {
            functionAttributes.forEach(functionAttribute -> functionAttribute.unParse(writer, context));
        }
        if (sqlNode.isSecurityDefiner()) {
            writer.append("SECURITY DEFINER ");
        }
        writer.newLine();
        this.processFunction(sqlNode, writer, context);
    }

    private void processLanguage(CreateSqlFunction sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getSqlFunctionLanguageSpec() != null) {
            writer.append("LANGUAGE SQL").newLine();
        }
    }

    private void processFunction(CreateSqlFunction sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("AS $$ ");
        writer.append("SELECT ");
        sqlNode.getExpression().unParse(writer, context);
        writer.append("$$");
    }
}

