/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.td.unparser;

import com.huawei.hwclouds.migration.td.UnParser;
import com.huawei.hwclouds.migration.td.UnParserAnnotation;
import com.huawei.hwclouds.migration.td.UnParserContext;
import com.huawei.hwclouds.migration.td.nodes.DataType;
import com.huawei.hwclouds.migration.td.nodes.TypeName;
import com.huawei.hwclouds.migration.td.util.SqlDialect;
import com.huawei.hwclouds.migration.td.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=DataType.class)
public class DataTypeUnParser
implements UnParser<DataType> {
    @Override
    public void unParse(DataType sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getTypeName() != null) {
            this.writeAppendDataType(sqlNode, writer, context);
        } else if (sqlNode.getUdtDataTypeName() != null) {
            writer.append(sqlNode.getUdtDataTypeName());
        } else if (sqlNode.getFullIdDataTypeName() != null) {
            writer.append(sqlNode.getFullIdDataTypeName());
        }
    }

    private void writeAppendDataType(DataType sqlNode, SqlWriter writer, UnParserContext context) {
        switch (sqlNode.getTypeName()) {
            case VARBYTE: 
            case VARGRAPHIC: 
            case GRAPHIC: 
            case BYTE: 
            case LONG_VARGRAPHIC: 
            case BINARY: {
                writer.append(sqlNode.getTypeName().getTarget());
                break;
            }
            case CHARACTER: 
            case CHAR: 
            case VARCHAR: 
            case CHAR_VARYING: {
                if (sqlNode.getCharacterSet() != null && (sqlNode.getCharacterSet().equalsIgnoreCase("LATIN") || sqlNode.getCharacterSet().equalsIgnoreCase("UNICODE"))) {
                    sqlNode.setTypeName(TypeName.NVARCHAR2);
                }
                writer.append(sqlNode.getTypeName().getTarget());
                if (sqlNode.getNumericParameter() == null) break;
                writer.append("(");
                sqlNode.getNumericParameter().unParse(writer, context);
                writer.append(")");
                break;
            }
            default: {
                writer.append(sqlNode.getTypeName().getTarget());
                if (sqlNode.getNumericParameter() != null) {
                    writer.append("(");
                    sqlNode.getNumericParameter().unParse(writer, context);
                    writer.append(")");
                }
                if (!sqlNode.isWithTimeZone()) break;
                writer.append(" WITH TIME ZONE");
            }
        }
    }
}

