/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.td.unparser;

import com.huawei.hwclouds.migration.td.UnParser;
import com.huawei.hwclouds.migration.td.UnParserAnnotation;
import com.huawei.hwclouds.migration.td.UnParserContext;
import com.huawei.hwclouds.migration.td.nodes.FunctionCallExpression;
import com.huawei.hwclouds.migration.td.nodes.SqlNode;
import com.huawei.hwclouds.migration.td.nodes.TypeName;
import com.huawei.hwclouds.migration.td.unparser.FormatUnParser;
import com.huawei.hwclouds.migration.td.util.SqlDialect;
import com.huawei.hwclouds.migration.td.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=FunctionCallExpression.class)
public class FunctionCallExpressionUnParser
extends FormatUnParser
implements UnParser<FunctionCallExpression> {
    @Override
    public void unParse(FunctionCallExpression sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getBuiltInFunction() != null) {
            sqlNode.getBuiltInFunction().unParse(writer, context);
        } else if (sqlNode.getUdfFunctionName() != null) {
            writer.append(sqlNode.getUdfFunctionName()).append("(");
            if (sqlNode.getArgList() != null) {
                sqlNode.getArgList().unParse(writer, context);
            }
            writer.append(")");
        } else {
            switch (sqlNode.getFunctionName()) {
                case MDIFF: {
                    this.unParseMDiff(sqlNode, writer, context);
                    break;
                }
                case CSUM: {
                    this.unParseCSum(sqlNode, writer, context);
                    break;
                }
                case CAST: {
                    this.unParseCast(sqlNode, writer, context);
                    break;
                }
                case NULLIFZERO: 
                case ZEROIFNULL: {
                    this.unParseWithZero(sqlNode, writer, context);
                    break;
                }
                case ADD_MONTHS: 
                case LAST_DAY: {
                    writer.append("MIG_EXT.");
                    this.appendFunctionArgs(sqlNode, writer, context);
                    break;
                }
                default: {
                    this.appendFunctionArgs(sqlNode, writer, context);
                }
            }
        }
    }

    private void appendFunctionArgs(FunctionCallExpression sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append(sqlNode.getFunctionName().getName()).append("(");
        if (sqlNode.getStarArg() != null) {
            writer.append(sqlNode.getStarArg());
        } else {
            if (sqlNode.getArgPrefix() != null) {
                writer.append(sqlNode.getArgPrefix()).writeSpace();
            }
            if (sqlNode.getArgList() != null) {
                sqlNode.getArgList().unParse(writer, context);
            }
        }
        writer.append(")");
        if (sqlNode.getWindowSpec() != null) {
            writer.writeSpace();
            sqlNode.getWindowSpec().unParse(writer, context);
        }
    }

    private void unParseCast(FunctionCallExpression sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getDataType() == null && sqlNode.getFormat() != null) {
            writer.append("TO_CHAR(");
            sqlNode.getArgList().unParse(writer, context);
            writer.append(",").append(this.convertDateTimeFormat(sqlNode.getFormat())).append(")");
        } else if (sqlNode.getDataType().getTypeName() == TypeName.TIMESTAMP && sqlNode.getFormat() != null) {
            writer.append("TO_TIMESTAMP(");
            sqlNode.getArgList().unParse(writer, context);
            writer.append(",").append(this.convertDateTimeFormat(sqlNode.getFormat()));
            writer.append(")");
        } else if (sqlNode.getDataType().getTypeName() == TypeName.TIME && sqlNode.getFormat() != null) {
            writer.append("CAST(to_timestamp(");
            sqlNode.getArgList().unParse(writer, context);
            this.convertDateTimeFormat(sqlNode.getFormat());
            writer.append(",").append(this.convertDateTimeFormat(sqlNode.getFormat()));
            writer.append(") as TIME)");
        } else if (sqlNode.getDataType().getTypeName() == TypeName.INTEGER) {
            writer.append("( ");
            sqlNode.getArgList().unParse(writer, context);
            writer.append(" )");
        } else if (sqlNode.getFormat() != null) {
            this.unParseFormat(sqlNode.getFormat(), sqlNode, writer, context, sqlNode.isFormatDate());
        } else {
            this.unParseExpression(sqlNode, writer, context);
        }
    }

    private String convertDateTimeFormat(String format) {
        if ((format = format.replace("B", " ")).contains("HH") && !format.contains("HH24")) {
            format = format.replace("HH", "HH24");
        }
        format = format.replace("S(6)", "US");
        format = format.replace("S(3)", "MS");
        format = format.replace("S(0)", "SS");
        return format;
    }

    @Override
    protected void unParseExpression(SqlNode sqlNode, SqlWriter writer, UnParserContext context) {
        FunctionCallExpression functionCallExpression = (FunctionCallExpression)sqlNode;
        writer.append("CAST(");
        if (functionCallExpression.getArgList() != null) {
            functionCallExpression.getArgList().unParse(writer, context);
        }
        writer.append(" AS ");
        functionCallExpression.getDataType().unParse(writer, context);
        writer.append(")");
    }

    private void unParseMDiff(FunctionCallExpression sqlNode, SqlWriter writer, UnParserContext context) {
        sqlNode.getArgList().unParse(writer, context);
        writer.append(" - LAG(");
        sqlNode.getArgList().unParse(writer, context);
        writer.append(",").append(sqlNode.getWidth()).append(",NULL)");
        if (sqlNode.getWindowSpec() != null) {
            writer.writeSpace();
            sqlNode.getWindowSpec().unParse(writer, context);
        }
    }

    private void unParseCSum(FunctionCallExpression sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("SUM (");
        sqlNode.getArgList().unParse(writer, context);
        writer.append(")");
        if (sqlNode.getWindowSpec() != null) {
            if (sqlNode.getWindowSpec().getWithRows() != null) {
                sqlNode.getWindowSpec().setWithRows("ROWS UNBOUNDED PRECEDING");
            }
            writer.writeSpace();
            sqlNode.getWindowSpec().unParse(writer, context);
        }
    }

    private void unParseWithZero(FunctionCallExpression sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append(sqlNode.getFunctionName().getName()).append("(");
        sqlNode.getArgList().unParse(writer, context);
        writer.append(", 0)");
    }
}

