/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.td.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.migration.td.UnParser;
import com.huawei.hwclouds.migration.td.UnParserAnnotation;
import com.huawei.hwclouds.migration.td.UnParserContext;
import com.huawei.hwclouds.migration.td.nodes.ElseIfStatement;
import com.huawei.hwclouds.migration.td.nodes.IfStatement;
import com.huawei.hwclouds.migration.td.util.SqlDialect;
import com.huawei.hwclouds.migration.td.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=IfStatement.class)
public class IfStatementUnParser
implements UnParser<IfStatement> {
    @Override
    public void unParse(IfStatement sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("IF").writeSpace();
        sqlNode.getConditionalExpression().unParse(writer, context);
        writer.append("THEN").writeSpace();
        if (sqlNode.getStatements() == null || sqlNode.getStatements().getStatementList().isEmpty()) {
            throw new ParserRuntimeException(ParserExceptionDef.NON_COMPLIANT_STATEMENT, "if then clause can not be null");
        }
        sqlNode.getStatements().unParse(writer, context);
        writer.newLine();
        if (sqlNode.getElseIfStatementList() != null) {
            for (ElseIfStatement elseIfStatement : sqlNode.getElseIfStatementList()) {
                writer.append("ELSIF").writeSpace();
                elseIfStatement.getConditionalExpression().unParse(writer, context);
                writer.append("THEN").writeSpace();
                elseIfStatement.getStatements().unParse(writer, context);
                writer.newLine();
            }
        }
        if (sqlNode.getElseStatements() != null && !sqlNode.getElseStatements().getStatementList().isEmpty()) {
            writer.append("ELSE").writeSpace();
            sqlNode.getElseStatements().unParse(writer, context);
            writer.newLine();
        }
        writer.append("END IF");
    }
}

