/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.td.unparser;

import com.huawei.hwclouds.migration.td.UnParser;
import com.huawei.hwclouds.migration.td.UnParserAnnotation;
import com.huawei.hwclouds.migration.td.UnParserContext;
import com.huawei.hwclouds.migration.td.nodes.LocalDeclaration;
import com.huawei.hwclouds.migration.td.util.SqlDialect;
import com.huawei.hwclouds.migration.td.writer.SqlWriter;
import java.util.List;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=LocalDeclaration.class)
public class LocalDeclarationUnParser
implements UnParser<LocalDeclaration> {
    @Override
    public void unParse(LocalDeclaration sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getVariableNameList() == null || sqlNode.getVariableNameList().isEmpty()) {
            return;
        }
        List<String> variableNameList = sqlNode.getVariableNameList();
        for (int i = 0; i < variableNameList.size(); ++i) {
            String variableName = variableNameList.get(i);
            writer.append("DECLARE");
            writer.writeSpace().append(variableName);
            if (sqlNode.getDataType() != null) {
                writer.writeSpace();
                sqlNode.getDataType().unParse(writer, context);
            }
            if (sqlNode.getExpressionAtom() != null) {
                writer.writeSpace().append("DEFAULT").writeSpace();
                sqlNode.getExpressionAtom().unParse(writer, context);
            }
            if (sqlNode.getConditionName() != null) {
                writer.writeSpace().append(sqlNode.getConditionName()).writeSpace().append("CONDITION");
                if (sqlNode.getSqlstateCode() != null) {
                    writer.writeSpace().append("FOR").writeSpace().append(sqlNode.getSqlstateCode());
                }
            }
            if (i == variableNameList.size() - 1) continue;
            writer.sqlEnd().newLine();
        }
    }
}

