/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.td.unparser;

import com.huawei.hwclouds.migration.td.UnParser;
import com.huawei.hwclouds.migration.td.UnParserAnnotation;
import com.huawei.hwclouds.migration.td.UnParserContext;
import com.huawei.hwclouds.migration.td.nodes.LockingSpecification;
import com.huawei.hwclouds.migration.td.util.SqlDialect;
import com.huawei.hwclouds.migration.td.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=LockingSpecification.class)
public class LockingSpecificationUnParser
implements UnParser<LockingSpecification> {
    @Override
    public void unParse(LockingSpecification sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("/* ");
        writer.append(sqlNode.getLockKeyword() + " ");
        if (sqlNode.getItemToLock().isDatabase()) {
            writer.append("DATABASE ");
        } else if (sqlNode.getItemToLock().isTable()) {
            writer.append("TABLE ");
        } else if (sqlNode.getItemToLock().isView()) {
            writer.append("VIEW ");
        } else if (sqlNode.getItemToLock().isRow()) {
            writer.append("ROW ");
        } else {
            writer.append("UNKNOWN ");
        }
        writer.append(sqlNode.getItemToLock().getName() + " ");
        if (sqlNode.getPreposition() != null) {
            writer.append(sqlNode.getPreposition() + " ");
        }
        writer.append(sqlNode.getLockType() + " ");
        if (sqlNode.isMode()) {
            writer.append(" MODE");
        }
        if (sqlNode.isNoWait()) {
            writer.append(" NOWAIT");
        }
        writer.append(" */");
    }
}

