/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.td.unparser;

import com.huawei.hwclouds.migration.td.UnParser;
import com.huawei.hwclouds.migration.td.UnParserAnnotation;
import com.huawei.hwclouds.migration.td.UnParserContext;
import com.huawei.hwclouds.migration.td.nodes.ColumnIndex;
import com.huawei.hwclouds.migration.td.nodes.Statistic;
import com.huawei.hwclouds.migration.td.util.SqlDialect;
import com.huawei.hwclouds.migration.td.writer.SqlWriter;
import java.util.List;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=Statistic.class)
public class StatisticUnparser
implements UnParser<Statistic> {
    @Override
    public void unParse(Statistic sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getIndexName() != null) {
            if (sqlNode.isUnique()) {
                writer.append("UNIQUE ");
            }
            writer.append("INDEX ").append(sqlNode.getIndexName()).writeSpace();
            if (sqlNode.isAll()) {
                writer.append("ALL ");
            }
            writer.append("( ").append(sqlNode.getColumnName()).append(")");
        } else {
            List<ColumnIndex> nodes = sqlNode.getColumnIndex();
            if (nodes.size() > 1) {
                writer.append("( ");
                for (int i = 0; i < nodes.size(); ++i) {
                    ColumnIndex node = nodes.get(i);
                    node.unParse(writer, context);
                    if (i >= nodes.size() - 1) continue;
                    writer.append(", ");
                }
                writer.append(" )");
            } else {
                nodes.get(0).unParse(writer, context);
            }
        }
    }
}

