/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.td.unparser;

import com.huawei.hwclouds.migration.td.UnParser;
import com.huawei.hwclouds.migration.td.UnParserAnnotation;
import com.huawei.hwclouds.migration.td.UnParserContext;
import com.huawei.hwclouds.migration.td.nodes.ColumnPartitionDefinitionItem;
import com.huawei.hwclouds.migration.td.nodes.TableFunctionReference;
import com.huawei.hwclouds.migration.td.util.SqlDialect;
import com.huawei.hwclouds.migration.td.writer.SqlWriter;
import java.util.List;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=TableFunctionReference.class)
public class TableFunctionReferenceUnParser
implements UnParser<TableFunctionReference> {
    @Override
    public void unParse(TableFunctionReference sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append(sqlNode.getFunctionName());
        if (sqlNode.getExprSpec() != null) {
            sqlNode.getExprSpec().unParse(writer, context);
        } else {
            writer.append("()");
        }
        if (sqlNode.getAs() != null) {
            writer.writeSpace();
            writer.append(sqlNode.getAs());
        }
        if (sqlNode.getAliasName() != null) {
            writer.writeSpace();
            writer.append(sqlNode.getAliasName());
        }
        if (sqlNode.getColumnList() != null) {
            List<ColumnPartitionDefinitionItem> columnNodes = sqlNode.getColumnList().getNodes();
            writer.append("(");
            for (int i = 0; i < columnNodes.size(); ++i) {
                writer.append(columnNodes.get(i).getColId());
                if (i >= columnNodes.size() - 1) continue;
                writer.append(",");
            }
            writer.append(")");
        }
    }
}

