/*
 * Decompiled with CFR 0.152.
 */
package com.github.vertical_blank.sqlformatter.core;

import com.github.vertical_blank.sqlformatter.core.Params;
import java.util.List;
import java.util.Map;

public class FormatConfig {
    public static final String DEFAULT_INDENT = "  ";
    public static final int DEFAULT_COLUMN_MAX_LENGTH = 50;
    public final String indent;
    public final int maxColumnLength;
    public final Params params;
    public final boolean uppercase;
    public final Integer linesBetweenQueries;

    FormatConfig(String indent, int maxColumnLength, Params params, boolean uppercase, Integer linesBetweenQueries) {
        this.indent = indent;
        this.maxColumnLength = maxColumnLength;
        this.params = params == null ? Params.EMPTY : params;
        this.uppercase = uppercase;
        this.linesBetweenQueries = linesBetweenQueries;
    }

    public static FormatConfigBuilder builder() {
        return new FormatConfigBuilder();
    }

    public static class FormatConfigBuilder {
        private String indent = "  ";
        private int maxColumnLength = 50;
        private Params params;
        private boolean uppercase;
        private Integer linesBetweenQueries;

        FormatConfigBuilder() {
        }

        public FormatConfigBuilder indent(String indent) {
            this.indent = indent;
            return this;
        }

        public FormatConfigBuilder maxColumnLength(int maxColumnLength) {
            this.maxColumnLength = maxColumnLength;
            return this;
        }

        public FormatConfigBuilder params(Params params) {
            this.params = params;
            return this;
        }

        public FormatConfigBuilder params(Map<String, ?> params) {
            return this.params(Params.of(params));
        }

        public FormatConfigBuilder params(List<?> params) {
            return this.params(Params.of(params));
        }

        public FormatConfigBuilder uppercase(boolean uppercase) {
            this.uppercase = uppercase;
            return this;
        }

        public FormatConfigBuilder linesBetweenQueries(int linesBetweenQueries) {
            this.linesBetweenQueries = linesBetweenQueries;
            return this;
        }

        public FormatConfig build() {
            return new FormatConfig(this.indent, this.maxColumnLength, this.params, this.uppercase, this.linesBetweenQueries);
        }
    }
}

