CREATE OR REPLACE VIEW mig_td_ext.vw_td_dbc_indices
/*  This view is used to support some specific columns like
    tablename, columnname in the TD system view "dbc.indices"
*/
AS
SELECT CAST(ns.nspname AS VARCHAR(64)) 
			AS schemaname
     , CAST(t.relname AS VARCHAR(64)) 
			AS tablename
     , CAST(a.attname AS VARCHAR(64)) 
			AS columnname
  FROM pg_catalog.pg_class t
     , pg_catalog.pgxc_class ix
     , pg_catalog.pg_attribute a
     , pg_catalog.pg_namespace ns
 WHERE t.relkind     = 'r'
   AND ix.pcrelid    = t.oid
   AND a.attrelid    = ix.pcrelid
   AND a.attnum      = ANY(ix.pcattnum)
   AND ns.oid        = t.relnamespace 
 ORDER BY ns.nspname, t.relname;

