CREATE OR REPLACE VIEW mig_td_ext.vw_td_dbc_tables
/*  This view is used to support some specific columns like
    tablename, tablekind in the TD system view "dbc.tables"
*/
AS       
SELECT CAST(ns.nspname AS VARCHAR(64)) 
			AS schemaname
     , CAST(c.relname AS VARCHAR(64)) 
			AS tablename
     , CAST(DECODE(c.relkind, 'r', 'T', 'v', 'V') AS CHAR(1)) 
			AS tablekind
  FROM pg_catalog.pg_class c
     , pg_catalog.pg_namespace ns
 WHERE ns.oid       = c.relnamespace 
   AND c.relkind    IN ('r', 'v')
 UNION ALL
SELECT ns.nspname, p.proname, 'F'
  FROM pg_catalog.pg_proc p
     , pg_catalog.pg_namespace ns
 WHERE ns.oid       = p.pronamespace 
 UNION ALL
SELECT ns.nspname, t.typname, 'T'
  FROM pg_catalog.pg_type t
     , pg_catalog.pg_namespace ns
 WHERE ns.oid        = t.typnamespace 
   AND t.typcategory = 'U'
ORDER BY schemaname, tablename;

