from scripts.verifyGaussPython.src.python.shell_utils import execute_script, execute_script_write, \
    execute_script_write_t, execute_pre_setup_file, execute_pre_setup_file_t


def rungaussdbaconnection(configdata):
    """Run gauss input file """
    cmd = "gsql -d {0} -p {1} -U {2} -W {3} -h {4} ".format(configdata['gaussdb-name'], configdata['gaussdb-port'],
                                                            configdata['gaussdb-user'], configdata['gaussdb-password'],
                                                            configdata['gaussdb-ip'])
    return execute_script(cmd)


def rungaussdbtconnection(configdata):
    """Run gauss input file """
    cmd = "zsql {0}/{1}@{2}:{3} -q ".format(configdata['gaussdb-user'], configdata['gaussdb-password'],
                                            configdata['gaussdb-ip'], configdata['gaussdb-port'])
    return execute_script(cmd)


def rungauss100scriptfile(ip, port, username, password, filename, successoutputfile):
    """Run gauss input file """

    cmd = "zsql {0}/{1}@{2}:{3} -q -f {4} ".format(username, password, ip, port, filename)
    return execute_script_write(cmd, successoutputfile, filename, successoutputfile)


def rungauss200scriptfile(dbname, port, username, password, hostname, filename, successoutputfile, errorlogfile):
    """Run gauss input file """

    cmd = "gsql -d {0} -p {1} -U {2} -W {3} -h {4} -f {5} ".format(dbname, port, username, password, hostname, filename)
    return execute_script_write(cmd, successoutputfile, filename, errorlogfile)


def rungauss100scriptfile_file(ip, port, username, password, scriptfile, successoutputfile, errorlogfile, file_name,
                               line_number, flag):
    """Run gauss input file """

    cmd = "zsql {0}/{1}@{2}:{3} -q -f {4} ".format(username, password, ip, port, scriptfile)
    return execute_script_write_t(cmd, successoutputfile, errorlogfile, file_name, line_number, flag)


def run_pre_setup_file_a(dbname, port, username, password, hostname, filename, outputfilename, outputerrorfilename):
    """Run gauss input file """
    cmd = "gsql -d {0} -p {1} -U {2} -W {3} -h {4} -f {5} ".format(dbname, port, username, password, hostname, filename)
    return execute_pre_setup_file(cmd, outputfilename, outputerrorfilename, filename)


def run_pre_setup_file_t(username, password, hostname, port, filename, outputfilename, outputerrorfilename):
    """Run gauss input file """

    cmd = "zsql {0}/{1}@{2}:{3} -q -f {4} ".format(username, password, hostname, port, filename)
    return execute_pre_setup_file_t(cmd, outputfilename, outputerrorfilename, filename)
