/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss200.jdbc.geometric;

import com.huawei.gauss200.jdbc.geometric.PGpoint;
import com.huawei.gauss200.jdbc.util.GT;
import com.huawei.gauss200.jdbc.util.PGobject;
import com.huawei.gauss200.jdbc.util.PGtokenizer;
import com.huawei.gauss200.jdbc.util.PSQLException;
import com.huawei.gauss200.jdbc.util.PSQLState;
import java.io.Serializable;
import java.sql.SQLException;

public class PGcircle
extends PGobject
implements Serializable,
Cloneable {
    public PGpoint center;
    public double radius;

    public PGcircle(double x, double y, double r) {
        this(new PGpoint(x, y), r);
    }

    public PGcircle(PGpoint c, double r) {
        this();
        this.center = c;
        this.radius = r;
    }

    public PGcircle(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public PGcircle() {
        this.type = "circle";
    }

    @Override
    public void setValue(String s) throws SQLException {
        if (s == null) {
            throw new PSQLException(GT.tr("Conversion to type Circle failed, null info: {0}.", new Object[0]), PSQLState.DATA_TYPE_MISMATCH);
        }
        PGtokenizer t = new PGtokenizer(PGtokenizer.removeAngle(s), ',');
        if (t.getSize() != 2) {
            throw new PSQLException(GT.tr("Conversion to type {0} failed: {1}.", this.type, s), PSQLState.DATA_TYPE_MISMATCH);
        }
        try {
            this.center = new PGpoint(t.getToken(0));
            this.radius = Double.parseDouble(t.getToken(1));
        }
        catch (NumberFormatException e) {
            throw new PSQLException(GT.tr("Conversion to type {0} failed: {1}.", this.type, s), PSQLState.DATA_TYPE_MISMATCH, (Throwable)e);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PGcircle) {
            PGcircle p = (PGcircle)obj;
            PGpoint center = this.center;
            PGpoint pCenter = p.center;
            if (center == null) {
                return pCenter == null;
            }
            if (pCenter == null) {
                return false;
            }
            return p.radius == this.radius && PGcircle.equals(pCenter, center);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.center == null) {
            return 0;
        }
        long bits = Double.doubleToLongBits(this.radius);
        int v = (int)(bits ^ bits >>> 32);
        v = v * 31 + this.center.hashCode();
        return v;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PGcircle newPGcircle = (PGcircle)super.clone();
        if (newPGcircle.center != null) {
            newPGcircle.center = (PGpoint)newPGcircle.center.clone();
        }
        return newPGcircle;
    }

    @Override
    public String getValue() {
        return this.center == null ? null : "<" + this.center + "," + this.radius + ">";
    }
}

