/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import com.huawei.dws.pbq.api.model.RowType;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import org.postgresql.Driver;
import org.postgresql.core.ServerVersion;
import org.postgresql.jdbc.PayByQueryConnection;
import org.postgresql.util.internal.Nullness;

public class PbqResultSetMetaData
implements ResultSetMetaData {
    private PayByQueryConnection connection;
    private List<RowType> rowTypes;

    PbqResultSetMetaData(PayByQueryConnection connection, List<RowType> rowTypes) {
        this.connection = connection;
        this.rowTypes = rowTypes;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.rowTypes.size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        RowType rowType = this.getRowType(column);
        return this.connection.getTypeInfo().isCaseSensitive(rowType.getType());
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        String typeName = this.getPGType(column);
        return "cash".equals(typeName) || "money".equals(typeName);
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 1;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this.connection.getTypeInfo().isSigned(this.getRowType(column).getType());
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        RowType rowType = this.getRowType(column);
        return this.connection.getTypeInfo().getDisplaySize(rowType.getType(), rowType.getTypemod());
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        RowType rowType = this.rowTypes.get(column - 1);
        return rowType.getName();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.getColumnLabel(column);
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        RowType rowType = this.rowTypes.get(column - 1);
        return null;
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        RowType rowType = this.rowTypes.get(column - 1);
        return this.connection.getTypeInfo().getPrecision(rowType.getType(), rowType.getTypemod());
    }

    @Override
    public int getScale(int column) throws SQLException {
        RowType rowType = this.rowTypes.get(column - 1);
        return this.connection.getTypeInfo().getScale(rowType.getType(), rowType.getTypemod());
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return null;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.getSQLType(column);
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        String type = this.getPGType(column);
        if (this.isAutoIncrement(column)) {
            if ("int4".equals(type)) {
                return "serial";
            }
            if ("int8".equals(type)) {
                return "bigserial";
            }
            if ("int2".equals(type) && this.connection.haveMinimumServerVersion(ServerVersion.v9_2)) {
                return "smallserial";
            }
        }
        return Nullness.castNonNull(type);
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return !this.isReadOnly(column);
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        RowType rowType = this.getRowType(column);
        String result = this.connection.getTypeInfo().getJavaClass(rowType.getType());
        if (result != null) {
            return result;
        }
        int sqlType = this.getSQLType(column);
        switch (sqlType) {
            case 2003: {
                return "java.sql.Array";
            }
        }
        String type = this.getPGType(column);
        if ("unknown".equals(type)) {
            return "java.lang.String";
        }
        return "java.lang.Object";
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "unwrap(Class<T>)");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "isWrapperFor(Class<?>)");
    }

    protected int getSQLType(int columnIndex) throws SQLException {
        return this.connection.getTypeInfo().getSQLType(this.getRowType(columnIndex).getType());
    }

    public RowType getRowType(int columnIndex) {
        RowType rowType = this.rowTypes.get(columnIndex - 1);
        return rowType;
    }

    protected String getPGType(int columnIndex) throws SQLException {
        return this.connection.getTypeInfo().getPGType(this.getRowType(columnIndex).getType());
    }
}

