/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import com.huawei.dws.pbq.api.model.StatementResult;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.postgresql.jdbc.PbqResultSet;
import org.postgresql.jdbc.PbqStatement;

public class PbqStatementResultHandler {
    private List<StatementResult> results = new ArrayList<StatementResult>();
    private int index = 0;
    private PbqStatement statement;

    PbqStatementResultHandler(PbqStatement statement) {
        this.statement = statement;
    }

    PbqStatementResultHandler() {
    }

    public void addResult(StatementResult result) {
        this.results.add(result);
    }

    public void addResult(List<StatementResult> results) {
        this.results.addAll(results);
    }

    public PbqResultSet getResultSet(int maxFieldSize) throws SQLException {
        if (this.index >= this.results.size()) {
            return null;
        }
        StatementResult result = this.results.get(this.index);
        if (result.getResultSet() == null || result.getResultSet().getRows() == null) {
            return null;
        }
        return new PbqResultSet(result, this.statement, maxFieldSize);
    }

    public boolean next() {
        ++this.index;
        return this.index < this.results.size();
    }

    public void closeAllPrevious() {
        for (int i = 0; i < this.index; ++i) {
            StatementResult result = this.results.get(i);
            List rows = result.getResultSet().getRows();
            Object var3_3 = null;
        }
    }

    public long getUpdateCount() {
        if (this.index >= this.results.size()) {
            return -1L;
        }
        StatementResult result = this.results.get(this.index);
        if (result.getResultSet() != null && result.getResultSet().getRows() != null) {
            return -1L;
        }
        return result.getRowCount();
    }

    public int[] getBatchUpdateCount() {
        if (this.index >= this.results.size()) {
            return new int[]{0};
        }
        StatementResult result = this.results.get(this.index);
        int[] updates = new int[this.results.size()];
        return updates;
    }
}

