/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.sql.SQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.ServerErrorMessage;

public class PSQLException
extends SQLException {
    private ServerErrorMessage serverError;

    public PSQLException(String msg, PSQLState state, Throwable cause) {
        super(msg, state == null ? null : state.getState(), cause);
    }

    public PSQLException(String msg, PSQLState state, int errorcode, Throwable cause) {
        super(msg, state == null ? null : state.getState(), errorcode);
        this.initCause(cause);
    }

    public PSQLException(String msg, PSQLState state) {
        super(msg, state == null ? null : state.getState());
    }

    public PSQLException(String msg, PSQLState state, int errorcode) {
        this(msg, state, errorcode, null);
    }

    public PSQLException(ServerErrorMessage serverError) {
        super(serverError.toString(), serverError.getSQLState(), serverError.getERRORCODE() != null ? Integer.parseInt(serverError.getERRORCODE()) : 0);
        this.serverError = serverError;
    }

    public PSQLException(ServerErrorMessage serverError, boolean detail) {
        super(detail ? serverError.toString() : serverError.getNonSensitiveErrorMessage(), serverError.getSQLState());
        this.serverError = serverError;
    }

    public ServerErrorMessage getServerErrorMessage() {
        return this.serverError;
    }
}

