/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.shade.com.cloud.sdk;

import com.huawei.shade.com.cloud.sdk.Request;
import com.huawei.shade.com.cloud.sdk.WebServiceRequest;
import com.huawei.shade.com.cloud.sdk.http.HttpMethodName;
import com.huawei.shade.org.apache.http.annotation.NotThreadSafe;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

@NotThreadSafe
public class DefaultRequest<T>
implements Request<T> {
    private String resourcePath;
    private Map<String, String> parameters = new LinkedHashMap<String, String>();
    private Map<String, String> headers = new HashMap<String, String>();
    private URI endpoint;
    private String serviceName;
    private final WebServiceRequest originalRequest;
    private HttpMethodName httpMethod = HttpMethodName.POST;
    private InputStream content;
    private int timeOffset;

    public DefaultRequest(WebServiceRequest originalRequest, String serviceName) {
        this.serviceName = serviceName;
        this.originalRequest = originalRequest == null ? WebServiceRequest.NOOP : originalRequest;
    }

    public DefaultRequest(String serviceName) {
        this(null, serviceName);
    }

    @Override
    public WebServiceRequest getOriginalRequest() {
        return this.originalRequest;
    }

    @Override
    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    @Override
    public String getResourcePath() {
        return this.resourcePath;
    }

    @Override
    public void addParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    public Request<T> withParameter(String name, String value) {
        this.addParameter(name, value);
        return this;
    }

    @Override
    public HttpMethodName getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public void setHttpMethod(HttpMethodName httpMethod) {
        this.httpMethod = httpMethod;
    }

    @Override
    public void setEndpoint(URI endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public URI getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public InputStream getContent() {
        return this.content;
    }

    @Override
    public void setContent(InputStream content) {
        this.content = content;
    }

    @Override
    public void setHeaders(Map<String, String> headers) {
        this.headers.clear();
        this.headers.putAll(headers);
    }

    @Override
    public void setParameters(Map<String, String> parameters) {
        this.parameters.clear();
        this.parameters.putAll(parameters);
    }

    @Override
    public int getTimeOffset() {
        return this.timeOffset;
    }

    @Override
    public void setTimeOffset(int timeOffset) {
        this.timeOffset = timeOffset;
    }

    @Override
    public Request<T> withTimeOffset(int timeOffset) {
        this.setTimeOffset(timeOffset);
        return this;
    }

    public String toString() {
        String value;
        StringBuilder builder = new StringBuilder();
        builder.append((Object)this.getHttpMethod()).append(" ");
        builder.append(this.getEndpoint()).append(" ");
        String resourcePath = this.getResourcePath();
        if (resourcePath == null) {
            builder.append("/");
        } else {
            if (!resourcePath.startsWith("/")) {
                builder.append("/");
            }
            builder.append(resourcePath);
        }
        builder.append(" ");
        if (!this.getParameters().isEmpty()) {
            builder.append("Parameters: (");
            for (String key : this.getParameters().keySet()) {
                value = this.getParameters().get(key);
                builder.append(key).append(": ").append(value).append(", ");
            }
            builder.append(") ");
        }
        if (!this.getHeaders().isEmpty()) {
            builder.append("Headers: (");
            for (String key : this.getHeaders().keySet()) {
                value = this.getHeaders().get(key);
                builder.append(key).append(": ").append(value).append(", ");
            }
            builder.append(") ");
        }
        return builder.toString();
    }
}

