/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.shade.com.cloud.sdk;

import com.huawei.shade.com.cloud.sdk.ClientConfiguration;
import com.huawei.shade.com.cloud.sdk.auth.signer.RegionSigner;
import com.huawei.shade.com.cloud.sdk.auth.signer.Signer;
import com.huawei.shade.com.cloud.sdk.auth.signer.SignerFactory;
import com.huawei.shade.com.cloud.sdk.http.ExecutionContext;
import com.huawei.shade.com.cloud.sdk.http.InnerHttpClient;
import com.huawei.shade.com.cloud.sdk.http.RequestHandler;
import com.huawei.shade.com.cloud.sdk.util.Classes;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class WebServiceClient {
    private static final String SDK = "SDK";
    private static final String S = "S";
    private final Object lock = new Object();
    protected volatile URI endpoint;
    private volatile String serviceName;
    private volatile String signerRegionOverride;
    protected ClientConfiguration clientConfiguration;
    protected InnerHttpClient client;
    protected final List<RequestHandler> requestHandlers;
    protected int timeOffset;
    private volatile Signer signer;

    public WebServiceClient(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
        this.client = new InnerHttpClient(clientConfiguration);
        this.requestHandlers = new CopyOnWriteArrayList<RequestHandler>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEndpoint(String endpoint) throws IllegalArgumentException {
        URI uri = this.toURI(endpoint);
        Signer signer = this.computeSigner(this.signerRegionOverride);
        Object object = this.lock;
        synchronized (object) {
            this.endpoint = uri;
            this.signer = signer;
        }
    }

    private URI toURI(String endpoint) throws IllegalArgumentException {
        if (!endpoint.contains("://")) {
            endpoint = this.clientConfiguration.getProtocol().toString() + "://" + endpoint;
        }
        try {
            return new URI(endpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Signer getSigner() {
        if (this.signer != null) {
            return this.signer;
        }
        Signer signer = this.computeSigner(this.signerRegionOverride);
        Object object = this.lock;
        synchronized (object) {
            this.signer = signer;
        }
        return signer;
    }

    private Signer computeSigner(String signerRegionOverride) {
        String service = this.getServiceNameIntern();
        return this.computeSignerByServiceRegion(service, signerRegionOverride);
    }

    private Signer computeSignerByServiceRegion(String serviceName, String signerRegionOverride) {
        Signer signer;
        String signerType = this.clientConfiguration.getSignerOverride();
        Signer signer2 = signer = signerType == null ? SignerFactory.getSigner(serviceName, signerRegionOverride) : SignerFactory.getSignerByTypeAndService(signerType, serviceName);
        if (signer instanceof RegionSigner) {
            RegionSigner regionSigner = (RegionSigner)signer;
            if (signerRegionOverride != null) {
                regionSigner.setRegionName(signerRegionOverride);
            }
        }
        return signer;
    }

    public void shutdown() {
        this.client.shutdown();
    }

    public void addRequestHandler(RequestHandler requestHandler) {
        this.requestHandlers.add(requestHandler);
    }

    public void removeRequestHandler(RequestHandler requestHandler) {
        this.requestHandlers.remove(requestHandler);
    }

    protected final ExecutionContext createExecutionContext() {
        return new ExecutionContext(this.requestHandlers, this);
    }

    public void setTimeOffset(int timeOffset) {
        this.timeOffset = timeOffset;
    }

    public WebServiceClient withTimeOffset(int timeOffset) {
        this.setTimeOffset(timeOffset);
        return this;
    }

    public int getTimeOffset() {
        return this.timeOffset;
    }

    public String getServiceName() {
        return this.getServiceNameIntern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getServiceNameIntern() {
        if (this.serviceName == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.serviceName == null) {
                    this.serviceName = this.computeServiceNameByClazz();
                    return this.serviceName;
                }
            }
        }
        return this.serviceName;
    }

    public final void setServiceNameIntern(String serviceName) {
        this.serviceName = serviceName;
    }

    private String computeServiceNameByClazz() {
        int len;
        Class<?> httpClientClass = Classes.childClassOf(WebServiceClient.class, this);
        if (httpClientClass == null) {
            throw new IllegalStateException("Http client class is an anonymous class");
        }
        String httpClientName = httpClientClass.getSimpleName();
        int j = httpClientName.indexOf("JavaClient");
        if (j == -1 && (j = httpClientName.indexOf("Client")) == -1) {
            throw new IllegalStateException("Unrecognized suffix for the http client class name " + httpClientName);
        }
        int i = httpClientName.indexOf(SDK);
        if (i == -1) {
            i = httpClientName.indexOf(S);
            if (i == -1) {
                throw new IllegalStateException("Unrecognized prefix for the http client class name " + httpClientName);
            }
            len = S.length();
        } else {
            len = SDK.length();
        }
        if (i >= j) {
            throw new IllegalStateException("Unrecognized S http client class name " + httpClientName);
        }
        String serviceName = httpClientName.substring(i + len, j);
        return serviceName.toLowerCase();
    }

    public final String getSignerRegionOverride() {
        return this.signerRegionOverride;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSignerRegionOverride(String signerRegionOverride) {
        Signer signer = this.computeSigner(signerRegionOverride);
        Object object = this.lock;
        synchronized (object) {
            this.signer = signer;
            this.signerRegionOverride = signerRegionOverride;
        }
    }

    public <T extends WebServiceClient> T withEndpoint(String endpoint) {
        this.setEndpoint(endpoint);
        WebServiceClient t = this;
        return (T)t;
    }
}

