/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql;

import com.huawei.shade.com.alibaba.fastjson.JSONObject;
import com.huawei.shade.com.cloud.sdk.DefaultRequest;
import com.huawei.shade.com.cloud.sdk.auth.credentials.BasicCredentials;
import com.huawei.shade.com.cloud.sdk.auth.signer.Signer;
import com.huawei.shade.com.cloud.sdk.auth.signer.SignerFactory;
import com.huawei.shade.com.cloud.sdk.http.HttpMethodName;
import com.huawei.shade.org.apache.http.Header;
import com.huawei.shade.org.apache.http.client.methods.CloseableHttpResponse;
import com.huawei.shade.org.apache.http.client.methods.HttpGet;
import com.huawei.shade.org.apache.http.client.methods.HttpRequestBase;
import com.huawei.shade.org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import com.huawei.shade.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.huawei.shade.org.apache.http.conn.ssl.SSLContexts;
import com.huawei.shade.org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import com.huawei.shade.org.apache.http.conn.ssl.X509HostnameVerifier;
import com.huawei.shade.org.apache.http.impl.client.CloseableHttpClient;
import com.huawei.shade.org.apache.http.impl.client.HttpClients;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.postgresql.PGProperty;
import org.postgresql.jdbc.PayByQueryConnection;
import org.postgresql.jdbc.PgConnection;
import org.postgresql.util.GT;
import org.postgresql.util.HostSpec;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.SharedTimer;
import org.postgresql.util.URLCoder;
import org.postgresql.util.internal.Nullness;

public class Driver
implements java.sql.Driver {
    private static Driver registeredDriver;
    private static final Logger PARENT_LOGGER;
    private static final Logger LOGGER;
    private static final SharedTimer SHARED_TIMER;
    private static final String DEFAULT_PORT = "5431";
    private static final String DEFAULT_SERVLESS_PORT = "443";
    private static CloseableHttpClient client;
    private static final String gsVersion = "(GaussDB 9.1.1 build e364236a) compiled at 2025-12-01 15:44:21 commit 12055 last mr 28118 release";
    private static final String SERVERLESS_QUERY = "jdbc:fabricsql:";
    private static Connection queryCnListConnection;
    private static String connnectUrl;
    private static AtomicBoolean timerIsCalled;
    private static TimerTask task;
    private Properties defaultProperties;

    private synchronized Properties getDefaultProperties() throws IOException {
        if (this.defaultProperties != null) {
            return this.defaultProperties;
        }
        try {
            this.defaultProperties = AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){

                @Override
                public Properties run() throws IOException {
                    return Driver.this.loadDefaultProperties();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        return this.defaultProperties;
    }

    private Properties loadDefaultProperties() throws IOException {
        Properties merged = new Properties();
        try {
            PGProperty.USER.set(merged, System.getProperty("user.name"));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl == null) {
            LOGGER.log(Level.FINE, "Can't find our classloader for the Driver; attempt to use the system class loader");
            cl = ClassLoader.getSystemClassLoader();
        }
        if (cl == null) {
            LOGGER.log(Level.WARNING, "Can't find a classloader for the Driver; not loading driver configuration from org/postgresql/driverconfig.properties");
            return merged;
        }
        LOGGER.log(Level.FINE, "Loading driver configuration via classloader {0}", cl);
        ArrayList<URL> urls = new ArrayList<URL>();
        Enumeration<URL> urlEnum = cl.getResources("org/postgresql/driverconfig.properties");
        while (urlEnum.hasMoreElements()) {
            urls.add(urlEnum.nextElement());
        }
        for (int i = urls.size() - 1; i >= 0; --i) {
            URL url = (URL)urls.get(i);
            LOGGER.log(Level.FINE, "Loading driver configuration from: {0}", url);
            InputStream is = url.openStream();
            merged.load(is);
            is.close();
        }
        return merged;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        Boolean isChange;
        Properties defaults;
        if (url == null) {
            throw new SQLException("url is null");
        }
        if (!(url.startsWith("jdbc:postgresql:") || url.startsWith("jdbc:dws:iam:") || url.startsWith(SERVERLESS_QUERY))) {
            return null;
        }
        try {
            defaults = this.getDefaultProperties();
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Error loading default settings from driverconfig.properties", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)ioe);
        }
        Properties props = new Properties(defaults);
        if (info != null) {
            Set<String> e = info.stringPropertyNames();
            for (String propName : e) {
                String propValue = info.getProperty(propName);
                if (propValue == null) {
                    throw new PSQLException(GT.tr("Properties for the driver contains a non-string value for the key ", new Object[0]) + propName, PSQLState.UNEXPECTED_ERROR);
                }
                props.setProperty(propName, propValue);
            }
        }
        if (connnectUrl.isEmpty()) {
            connnectUrl = url;
        }
        if ((isChange = this.checkUrlChange(connnectUrl, url)) == null) {
            connnectUrl = "";
            return null;
        }
        if (isChange.booleanValue()) {
            connnectUrl = url;
            if (task != null) {
                task.cancel();
                SHARED_TIMER.getTimer().purge();
                timerIsCalled.set(true);
            }
        } else {
            timerIsCalled.set(false);
        }
        if ((props = Driver.parseURL(url, props)) == null) {
            return null;
        }
        String autoRecongnationCnsSwitch = PGProperty.CN_LIST_REFRESH_SWITCH.get(props);
        if (autoRecongnationCnsSwitch.equalsIgnoreCase("on") && (props = Driver.parseURL(url = connnectUrl, props)) == null) {
            return null;
        }
        if (autoRecongnationCnsSwitch.equalsIgnoreCase("on")) {
            Driver.regularQueryCnIpPort(props);
        }
        try {
            LOGGER.log(Level.FINE, "Connecting with URL: {0}", url);
            long timeout = Driver.timeout(props);
            if (timeout <= 0L) {
                return Driver.makeConnection(url, props);
            }
            ConnectThread ct = new ConnectThread(url, props);
            Thread thread = new Thread((Runnable)ct, "PostgreSQL JDBC driver connection thread");
            thread.setDaemon(true);
            thread.start();
            return ct.getResult(timeout);
        }
        catch (PSQLException ex1) {
            LOGGER.log(Level.FINE, "Connection error: ", ex1);
            throw ex1;
        }
        catch (AccessControlException ace) {
            throw new PSQLException(GT.tr("Your security policy has prevented the connection from being attempted.  You probably need to grant the connect java.net.SocketPermission to the database server host and port that you wish to connect to.", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)ace);
        }
        catch (Exception ex2) {
            LOGGER.log(Level.FINE, "Unexpected connection error: ", ex2);
            throw new PSQLException(GT.tr("Something unusual has occurred to cause the driver to fail. Please report this exception.", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)ex2);
        }
    }

    private Boolean checkUrlChange(String cacheUrl, String url) {
        String urlDatabase;
        if (!cacheUrl.startsWith("jdbc:postgresql:") || !url.startsWith("jdbc:postgresql:")) {
            return false;
        }
        String cacheUrlStr = this.parseUrl(cacheUrl);
        String urlStr = this.parseUrl(url);
        int slash = cacheUrlStr.indexOf(47);
        int urlSlash = urlStr.indexOf(47);
        if (slash == -1 || urlSlash == -1) {
            LOGGER.log(Level.WARNING, "JDBC URL must contain a / at the end of the host or port: {0}", url);
            return null;
        }
        List cacheUrlIp = Arrays.stream(cacheUrlStr.substring(0, cacheUrlStr.indexOf("/")).split(",")).collect(Collectors.toList());
        List urlIp = Arrays.stream(urlStr.substring(0, urlStr.indexOf("/")).split(",")).collect(Collectors.toList());
        for (String newUrlIp : urlIp) {
            if (cacheUrlIp.contains(newUrlIp)) continue;
            return true;
        }
        String cacheUrlDatabase = cacheUrlStr.substring(cacheUrlStr.indexOf("/") + 1);
        if (!cacheUrlDatabase.equals(urlDatabase = urlStr.substring(urlStr.indexOf("/") + 1))) {
            return true;
        }
        Map<String, String> cacheUrlMap = this.parseValue(cacheUrl);
        Map<String, String> urlMap = this.parseValue(url);
        if (urlMap.size() != cacheUrlMap.size()) {
            return true;
        }
        for (Map.Entry<String, String> entry : urlMap.entrySet()) {
            if (!cacheUrlMap.containsKey(entry.getKey())) {
                return true;
            }
            if (cacheUrlMap.get(entry.getKey()).equals(entry.getValue())) continue;
            return true;
        }
        return false;
    }

    private Map<String, String> parseValue(String url) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (url.startsWith("jdbc:postgresql:")) {
            String[] values;
            String urlArgs = "";
            int l_qPos = url.indexOf(63);
            if (l_qPos != -1) {
                urlArgs = url.substring(l_qPos + 1);
            }
            for (String value : values = urlArgs.split("&")) {
                String[] configs;
                if (value.isEmpty() || (configs = value.split("=")).length <= 1) continue;
                map.put(configs[0], configs[1]);
            }
        }
        return map;
    }

    private String parseUrl(String url) {
        if (url.startsWith("jdbc:postgresql:")) {
            String urlServer = url;
            int l_qPos = url.indexOf(63);
            if (l_qPos != -1) {
                urlServer = url.substring(0, l_qPos);
            }
            urlServer = urlServer.substring(urlServer.indexOf("//") + 2);
            return urlServer;
        }
        return "";
    }

    private List<String> getUrlIpInfo(String clusterUrl) {
        String[] ips;
        if (clusterUrl.isEmpty()) {
            return new ArrayList<String>();
        }
        String[] curUrl = clusterUrl.split("//");
        if (curUrl.length > 1 && (ips = curUrl[1].split("/")).length > 1) {
            return Arrays.stream(ips[0].split(",")).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    private static void regularQueryCnIpPort(final Properties props) {
        task = new TimerTask(){

            @Override
            public void run() {
                Statement statement = null;
                ResultSet resultSet = null;
                try {
                    int connectInvalidTimeOut = PGProperty.CONNECT_INVALID_TIMEOUT.getInt(props);
                    if (queryCnListConnection == null || !queryCnListConnection.isValid(connectInvalidTimeOut) || timerIsCalled.get()) {
                        queryCnListConnection = Driver.makeConnection(connnectUrl, props);
                    }
                    statement = queryCnListConnection.createStatement();
                    resultSet = statement.executeQuery("select node_host,node_port from pgxc_node where node_type='C'");
                    StringBuilder queryIpPortStr = new StringBuilder();
                    String[] urlIps = props.getProperty("PGHOST").split(",");
                    String[] urlPorts = props.getProperty("PGPORT").split(",");
                    HashSet<String> ipSet = new HashSet<String>();
                    for (int i = 0; i < urlIps.length; ++i) {
                        String ipPortStr = urlIps[i] + ":" + urlPorts[i];
                        ipSet.add(ipPortStr);
                    }
                    while (resultSet.next()) {
                        String databaseIpPort;
                        String ipAddr = resultSet.getString("node_host");
                        String port = resultSet.getString("node_port");
                        if (ipAddr.equals("localhost") || ipSet.contains(databaseIpPort = ipAddr + ":" + port)) continue;
                        ipSet.add(databaseIpPort);
                    }
                    for (String ipPort : ipSet) {
                        queryIpPortStr.append(ipPort).append(",");
                    }
                    queryIpPortStr.deleteCharAt(queryIpPortStr.lastIndexOf(","));
                    String[] oldUrls = connnectUrl.split("//");
                    String suffixUrl = oldUrls[1].substring(oldUrls[1].indexOf("/") + 1);
                    String newUrl = oldUrls[0] + "//" + queryIpPortStr + "/" + suffixUrl;
                    if (!connnectUrl.equals(newUrl)) {
                        connnectUrl = newUrl;
                    }
                }
                catch (SQLException e) {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (statement != null) {
                            statement.close();
                        }
                        if (queryCnListConnection != null) {
                            queryCnListConnection.close();
                        }
                    }
                    catch (SQLException ex) {
                        LOGGER.log(Level.FINE, "Close connection error:", ex);
                    }
                    LOGGER.log(Level.FINE, "JDBC driver connection error:", e);
                }
            }
        };
        try {
            int delay = PGProperty.CN_LIST_REFRESH_DELAY.getInt(props);
            int period = PGProperty.CN_LIST_REFRESH_PERIOD.getInt(props);
            SHARED_TIMER.getTimer().schedule(task, delay, (long)period);
        }
        catch (PSQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void setupLoggerFromProperties(Properties props) {
    }

    private static Connection makeConnection(String url, Properties props) throws SQLException {
        if (url.startsWith(SERVERLESS_QUERY)) {
            return new PayByQueryConnection(Driver.hostSpecs(props)[0], Driver.database(props), props, url);
        }
        return new PgConnection(Driver.hostSpecs(props), Driver.user(props), Driver.database(props), props, url);
    }

    @Override
    public boolean acceptsURL(String url) throws PSQLException {
        return Driver.parseURL(url, null) != null;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws PSQLException {
        Properties copy = new Properties(info);
        Properties parse = Driver.parseURL(url, copy);
        if (parse != null) {
            copy = parse;
        }
        PGProperty[] knownProperties = PGProperty.values();
        DriverPropertyInfo[] props = new DriverPropertyInfo[knownProperties.length];
        for (int i = 0; i < props.length; ++i) {
            props[i] = knownProperties[i].toDriverPropertyInfo(copy);
        }
        return props;
    }

    @Override
    public int getMajorVersion() {
        return 42;
    }

    @Override
    public int getMinorVersion() {
        return 2;
    }

    @Deprecated
    public static String getVersion() {
        return "PostgreSQL JDBC Driver 42.2.23";
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    public static Properties parseURL(String url, Properties defaults) throws PSQLException {
        Properties urlProps = new Properties(defaults);
        String urlServer = url;
        String urlArgs = "";
        int l_qPos = url.indexOf(63);
        if (l_qPos != -1) {
            urlServer = url.substring(0, l_qPos);
            urlArgs = url.substring(l_qPos + 1);
        }
        if (!(urlServer.startsWith("jdbc:postgresql:") || urlServer.startsWith("jdbc:dws:iam:") || url.startsWith(SERVERLESS_QUERY))) {
            LOGGER.log(Level.FINE, "JDBC URL must start with \"jdbc:postgresql:\" or \"jdbc:dws:iam:\" but was: {0}", url);
            return null;
        }
        if (urlServer.startsWith("jdbc:postgresql:")) {
            String[] args;
            if ((urlServer = urlServer.substring("jdbc:postgresql:".length())).startsWith("//")) {
                int slash = (urlServer = urlServer.substring(2)).indexOf(47);
                if (slash == -1) {
                    LOGGER.log(Level.WARNING, "JDBC URL must contain a / at the end of the host or port: {0}", url);
                    return null;
                }
                urlProps.setProperty("PGDBNAME", URLCoder.decode(urlServer.substring(slash + 1)));
                String[] addresses = urlServer.substring(0, slash).split(",");
                StringBuilder hosts = new StringBuilder();
                StringBuilder ports = new StringBuilder();
                for (String address : addresses) {
                    int portIdx = address.lastIndexOf(58);
                    if (portIdx != -1 && address.lastIndexOf(93) < portIdx) {
                        String portStr = address.substring(portIdx + 1);
                        try {
                            int port = Integer.parseInt(portStr);
                            if (port < 1 || port > 65535) {
                                LOGGER.log(Level.WARNING, "JDBC URL port: {0} not valid (1:65535) ", portStr);
                                return null;
                            }
                        }
                        catch (NumberFormatException ignore) {
                            LOGGER.log(Level.WARNING, "JDBC URL invalid port number: {0}", portStr);
                            return null;
                        }
                        ports.append(portStr);
                        hosts.append(address.subSequence(0, portIdx));
                    } else {
                        ports.append(DEFAULT_PORT);
                        hosts.append(address);
                    }
                    ports.append(',');
                    hosts.append(',');
                }
                String[] portArray = ports.toString().split(",");
                String[] hostArray = hosts.toString().split(",");
                for (int i = 0; i < hostArray.length; ++i) {
                    hostArray[i] = hostArray[i] + "," + portArray[i];
                }
                List<String> hostList = Arrays.asList(hostArray);
                hosts.setLength(0);
                ports.setLength(0);
                for (int i = 0; i < hostList.size(); ++i) {
                    String[] temp = hostList.get(i).toString().split(",");
                    hosts.append(temp[0]);
                    ports.append(temp[1]);
                    hosts.append(',');
                    ports.append(',');
                }
                ports.setLength(ports.length() - 1);
                hosts.setLength(hosts.length() - 1);
                urlProps.setProperty("PGPORT", ports.toString());
                urlProps.setProperty("PGHOST", hosts.toString());
            } else {
                if (defaults == null || !defaults.containsKey("PGPORT")) {
                    urlProps.setProperty("PGPORT", DEFAULT_PORT);
                }
                if (defaults == null || !defaults.containsKey("PGHOST")) {
                    urlProps.setProperty("PGHOST", "localhost");
                }
                if (defaults == null || !defaults.containsKey("PGDBNAME")) {
                    urlProps.setProperty("PGDBNAME", URLCoder.decode(urlServer));
                }
            }
            for (String token : args = urlArgs.split("&")) {
                if (token.isEmpty()) continue;
                int l_pos = token.indexOf(61);
                if (l_pos == -1) {
                    urlProps.setProperty(token, "");
                    continue;
                }
                urlProps.setProperty(token.substring(0, l_pos), URLCoder.decode(token.substring(l_pos + 1)));
            }
            return urlProps;
        }
        if (urlServer.startsWith("jdbc:dws:iam:")) {
            block65: {
                StringBuffer tmp = new StringBuffer();
                urlServer = urlServer.substring("jdbc:dws:iam:".length());
                String ClusterIdentifier = "";
                String region = "";
                String DbUser = "";
                String AutoCreate = "";
                String AccessKeyID = PGProperty.ACCESS_KEY_ID.get(urlProps);
                String SecretAccessKey = PGProperty.SECRET_ACCESS_KEY.get(urlProps);
                String addressType = PGProperty.ADDRESS_TYPE.get(urlProps);
                if (urlServer.startsWith("//")) {
                    int slash = (urlServer = urlServer.substring(2)).indexOf(47);
                    if (slash == -1) {
                        return null;
                    }
                    urlProps.setProperty("PGDBNAME", urlServer.substring(slash + 1));
                    String serverurl = urlServer.substring(0, slash);
                    String[] clusterurl = serverurl.split(":");
                    if (clusterurl.length != 2) {
                        return null;
                    }
                    ClusterIdentifier = clusterurl[0];
                    region = clusterurl[1];
                }
                String[] args = urlArgs.split("&");
                for (int i = 0; i < args.length; ++i) {
                    String token = args[i];
                    if (token.length() == 0) continue;
                    int l_pos = token.indexOf(61);
                    if (l_pos == -1) {
                        urlProps.setProperty(token, "");
                        continue;
                    }
                    if (token.substring(0, l_pos).equals("AccessKeyID")) {
                        AccessKeyID = token.substring(l_pos + 1);
                        continue;
                    }
                    if (token.substring(0, l_pos).equals("SecretAccessKey")) {
                        SecretAccessKey = token.substring(l_pos + 1);
                        continue;
                    }
                    if (token.substring(0, l_pos).equals("DbUser")) {
                        DbUser = token.substring(l_pos + 1);
                        continue;
                    }
                    if (token.substring(0, l_pos).equals("AutoCreate")) {
                        AutoCreate = token.substring(l_pos + 1);
                        continue;
                    }
                    if (token.substring(0, l_pos).equals("addressType")) {
                        addressType = token.substring(l_pos + 1);
                        continue;
                    }
                    tmp.append("&" + token.substring(0, l_pos) + "=" + token.substring(l_pos + 1));
                }
                StringBuffer jdbcUrl = new StringBuffer();
                if (region.equals("") || ClusterIdentifier.equals("") || DbUser.equals("") || AccessKeyID.equals("") || SecretAccessKey.equals("")) {
                    throw new PSQLException(GT.tr("Please confirm that all the parameters needed is added to the url.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                }
                InputStream in = null;
                Properties props = new Properties();
                String domainName = "";
                try {
                    File f = new File(Driver.class.getClassLoader().getResource("").getPath());
                    String filePath = f.getParent() + File.separator + "config" + File.separator + "jdbcconfig.properties";
                    in = new BufferedInputStream(new FileInputStream(filePath));
                    props = new Properties();
                    props.load(in);
                    domainName = props.getProperty(region);
                    in.close();
                }
                catch (Exception e) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ioe) {
                            LOGGER.log(Level.WARNING, ioe.getMessage());
                        }
                    }
                    try {
                        props = new Properties();
                        in = Driver.class.getResourceAsStream("/org/postgresql/jdbcconfig.properties");
                        props.load(in);
                        domainName = props.getProperty(region);
                        in.close();
                    }
                    catch (Exception e1) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException ioe) {
                                LOGGER.log(Level.WARNING, ioe.getMessage());
                            }
                        }
                        throw new PSQLException(GT.tr("Parse jdbcconfig.properties failed.", new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)e1);
                    }
                }
                if (domainName == null || domainName.equals("")) {
                    throw new PSQLException(GT.tr("Unrecognized region name.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                }
                jdbcUrl.append("https://" + domainName + "/credentials?");
                jdbcUrl.append("clusterName=" + ClusterIdentifier);
                jdbcUrl.append("&dbUser=" + DbUser);
                if (!AutoCreate.equals("")) {
                    jdbcUrl.append("&autoCreate=" + AutoCreate);
                }
                jdbcUrl.append("&addressType=" + addressType);
                jdbcUrl.append(tmp.toString());
                String jsonstr = "";
                jsonstr = Driver.getReturn(AccessKeyID, SecretAccessKey, jdbcUrl.toString(), region);
                try {
                    JSONObject jsonObj = JSONObject.parseObject(jsonstr);
                    if (jsonObj.get("cluster_credentials") != null) {
                        jsonstr = jsonObj.get("cluster_credentials").toString();
                        if ((jsonObj = JSONObject.parseObject(jsonstr)).get("db_user") != null) {
                            urlProps.setProperty("user", jsonObj.get("db_user").toString());
                        }
                        if (jsonObj.get("db_endpoint") != null) {
                            urlProps.setProperty("PGHOST", jsonObj.get("db_endpoint").toString());
                        }
                        if (jsonObj.get("db_port") != null) {
                            urlProps.setProperty("PGPORT", jsonObj.get("db_port").toString());
                        }
                        if (jsonObj.get("db_password") != null) {
                            urlProps.setProperty("password", jsonObj.get("db_password").toString());
                        }
                        break block65;
                    }
                    if (jsonObj.get("externalMessage") != null) {
                        throw new PSQLException(GT.tr(jsonObj.get("externalMessage").toString(), new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                    }
                    throw new PSQLException(GT.tr("The format of Token is not as expected.", new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                }
                catch (Exception e) {
                    throw new PSQLException(GT.tr("Parse the token failed.", new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)e);
                }
            }
            if (urlProps.getProperty("ssl") == null && urlProps.getProperty("sslmode") == null) {
                urlProps.setProperty("sslmode", "require");
            }
            return urlProps;
        }
        if (urlServer.startsWith(SERVERLESS_QUERY)) {
            String[] args;
            if ((urlServer = urlServer.substring(SERVERLESS_QUERY.length())).startsWith("//")) {
                int slash = (urlServer = urlServer.substring(2)).indexOf(47);
                if (slash == -1) {
                    LOGGER.log(Level.WARNING, "JDBC URL must contain a / at the end of the host or port: {0}", url);
                    return null;
                }
                urlProps.setProperty("PGDBNAME", URLCoder.decode(urlServer.substring(slash + 1)));
                String[] addresses = urlServer.substring(0, slash).split(",");
                StringBuilder hosts = new StringBuilder();
                StringBuilder ports = new StringBuilder();
                for (String address : addresses) {
                    int portIdx = address.lastIndexOf(58);
                    if (portIdx != -1 && address.lastIndexOf(93) < portIdx) {
                        String portStr = address.substring(portIdx + 1);
                        try {
                            int port = Integer.parseInt(portStr);
                            if (port < 1 || port > 65535) {
                                LOGGER.log(Level.WARNING, "JDBC URL port: {0} not valid (1:65535) ", portStr);
                                return null;
                            }
                        }
                        catch (NumberFormatException ignore) {
                            LOGGER.log(Level.WARNING, "JDBC URL invalid port number: {0}", portStr);
                            return null;
                        }
                        ports.append(portStr);
                        hosts.append(address.subSequence(0, portIdx));
                    } else {
                        ports.append(DEFAULT_SERVLESS_PORT);
                        hosts.append(address);
                    }
                    ports.append(',');
                    hosts.append(',');
                }
                String[] portArray = ports.toString().split(",");
                String[] hostArray = hosts.toString().split(",");
                for (int i = 0; i < hostArray.length; ++i) {
                    hostArray[i] = hostArray[i] + "," + portArray[i];
                }
                List<String> hostList = Arrays.asList(hostArray);
                hosts.setLength(0);
                ports.setLength(0);
                for (int i = 0; i < hostList.size(); ++i) {
                    String[] temp = hostList.get(i).toString().split(",");
                    hosts.append(temp[0]);
                    ports.append(temp[1]);
                    hosts.append(',');
                    ports.append(',');
                }
                ports.setLength(ports.length() - 1);
                hosts.setLength(hosts.length() - 1);
                urlProps.setProperty("PGPORT", ports.toString());
                urlProps.setProperty("PGHOST", hosts.toString());
            }
            for (String token : args = urlArgs.split("&")) {
                if (token.isEmpty()) continue;
                int l_pos = token.indexOf(61);
                if (l_pos == -1) {
                    urlProps.setProperty(token, "");
                    continue;
                }
                urlProps.setProperty(token.substring(0, l_pos), URLCoder.decode(token.substring(l_pos + 1)));
            }
            return urlProps;
        }
        return urlProps;
    }

    private static String getReturn(String ak, String sk, String requestUrl, String region) throws PSQLException {
        try {
            URL url = new URL(requestUrl);
            HttpMethodName httpMethod = HttpMethodName.GET;
            DefaultRequest request = new DefaultRequest("dws");
            request.setEndpoint(url.toURI());
            String urlString = url.toString();
            String parameters = null;
            if (urlString.contains("?")) {
                parameters = urlString.substring(urlString.indexOf("?") + 1);
                HashMap<String, String> parametersmap = new HashMap<String, String>();
                if (null != parameters && !"".equals(parameters)) {
                    String[] parameterarray;
                    for (String p : parameterarray = parameters.split("&")) {
                        String key = p.split("=")[0];
                        String value = p.split("=")[1];
                        parametersmap.put(key, value);
                    }
                    request.setParameters(parametersmap);
                }
            }
            request.setHttpMethod(httpMethod);
            Signer signer = SignerFactory.getSigner("dws", region);
            signer.sign(request, new BasicCredentials(ak, sk));
            HttpRequestBase httpRequestBase = Driver.createRequest(url, null);
            Map<String, String> requestHeaders = request.getHeaders();
            for (Map.Entry<String, String> entry : requestHeaders.entrySet()) {
                if (entry.getKey().equalsIgnoreCase("Content-Length".toString())) continue;
                httpRequestBase.addHeader(entry.getKey(), entry.getValue());
            }
            httpRequestBase.addHeader("X-Language", "en-us");
            httpRequestBase.addHeader("Content-Type", "application/json");
            httpRequestBase.addHeader("Accept", "application/json");
            CloseableHttpResponse response = null;
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, new TrustSelfSignedStrategy()).useTLS().build();
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (X509HostnameVerifier)new AllowAllHostnameVerifier());
            client = HttpClients.custom().setSSLSocketFactory(sslSocketFactory).build();
            response = client.execute(httpRequestBase);
            String string = Driver.convertStreamToString(response.getEntity().getContent());
            return string;
        }
        catch (Exception e) {
            throw new PSQLException(GT.tr("Get the token failed.", new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)e);
        }
        finally {
            try {
                if (client != null) {
                    client.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static HttpRequestBase createRequest(URL url, Header header) {
        HttpGet httpRequest = new HttpGet(url.toString());
        httpRequest.addHeader(header);
        return httpRequest;
    }

    private static String convertStreamToString(InputStream is) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (IOException ioEX) {
            throw ioEX;
        }
        finally {
            is.close();
        }
        return sb.toString();
    }

    private static HostSpec[] hostSpecs(Properties props) {
        String[] hosts = Nullness.castNonNull(props.getProperty("PGHOST")).split(",");
        String[] ports = Nullness.castNonNull(props.getProperty("PGPORT")).split(",");
        HostSpec[] hostSpecs = new HostSpec[hosts.length];
        for (int i = 0; i < hostSpecs.length; ++i) {
            hostSpecs[i] = new HostSpec(hosts[i], Integer.parseInt(ports[i]));
        }
        return hostSpecs;
    }

    private static String user(Properties props) {
        return props.getProperty("user", "");
    }

    private static String database(Properties props) {
        return props.getProperty("PGDBNAME", "");
    }

    private static long timeout(Properties props) {
        String timeout = PGProperty.LOGIN_TIMEOUT.get(props);
        if (timeout != null) {
            try {
                return (long)(Float.parseFloat(timeout) * 1000.0f);
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.WARNING, "Couldn't parse loginTimeout value: {0}", timeout);
            }
        }
        return (long)DriverManager.getLoginTimeout() * 1000L;
    }

    public static SQLFeatureNotSupportedException notImplemented(Class<?> callClass, String functionName) {
        return new SQLFeatureNotSupportedException(GT.tr("Method {0} is not yet implemented.", callClass.getName() + "." + functionName), PSQLState.NOT_IMPLEMENTED.getState());
    }

    @Override
    public Logger getParentLogger() {
        return PARENT_LOGGER;
    }

    public static SharedTimer getSharedTimer() {
        return SHARED_TIMER;
    }

    public static AtomicBoolean getTimerIsCalled() {
        return timerIsCalled;
    }

    public static TimerTask getTimerTask() {
        return task;
    }

    public static void register() throws SQLException {
        if (Driver.isRegistered()) {
            throw new IllegalStateException("Driver is already registered. It can only be registered once.");
        }
        Driver registeredDriver = new Driver();
        DriverManager.registerDriver(registeredDriver);
        Driver.registeredDriver = registeredDriver;
    }

    public static void deregister() throws SQLException {
        if (registeredDriver == null) {
            throw new IllegalStateException("Driver is not registered (or it has not been registered using Driver.register() method)");
        }
        DriverManager.deregisterDriver(registeredDriver);
        registeredDriver = null;
    }

    public static boolean isRegistered() {
        return registeredDriver != null;
    }

    public static String getGSVersion() {
        return gsVersion;
    }

    private static boolean connectionExtraInfo(Properties prop) {
        return Boolean.valueOf(prop.getProperty("connectionExtraInfo", "false"));
    }

    static {
        PARENT_LOGGER = Logger.getLogger("org.postgresql");
        LOGGER = Logger.getLogger("org.postgresql.Driver");
        SHARED_TIMER = new SharedTimer();
        client = null;
        queryCnListConnection = null;
        connnectUrl = "";
        timerIsCalled = new AtomicBoolean(false);
        task = null;
        try {
            Driver.register();
        }
        catch (SQLException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static class ConnectThread
    implements Runnable {
        private final String url;
        private final Properties props;
        private Connection result;
        private Throwable resultException;
        private boolean abandoned;

        ConnectThread(String url, Properties props) {
            this.url = url;
            this.props = props;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Throwable error;
            Connection conn;
            try {
                conn = Driver.makeConnection(this.url, this.props);
                error = null;
            }
            catch (Throwable t) {
                conn = null;
                error = t;
            }
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                if (this.abandoned) {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                } else {
                    this.result = conn;
                    this.resultException = error;
                    this.notify();
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Connection getResult(long timeout) throws SQLException {
            long expiry = TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) + timeout;
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                while (this.result == null) {
                    if (this.resultException != null) {
                        if (this.resultException instanceof SQLException) {
                            this.resultException.fillInStackTrace();
                            throw (SQLException)this.resultException;
                        }
                        throw new PSQLException(GT.tr("Something unusual has occurred to cause the driver to fail. Please report this exception.", new Object[0]), PSQLState.UNEXPECTED_ERROR, this.resultException);
                    }
                    long delay = expiry - TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
                    if (delay <= 0L) {
                        this.abandoned = true;
                        throw new PSQLException(GT.tr("Connection attempt timed out.", new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                    }
                    try {
                        this.wait(delay);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        this.abandoned = true;
                        throw new RuntimeException(GT.tr("Interrupted while attempting to connect.", new Object[0]));
                    }
                }
                return this.result;
            }
        }
    }
}

