/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import com.huawei.dws.pbq.api.DwsRestClient;
import com.huawei.dws.pbq.api.exception.DwsApiException;
import com.huawei.dws.pbq.api.model.StatementResult;
import com.huawei.dws.pbq.api.request.CreateSessionRequest;
import com.huawei.dws.pbq.api.request.LakeFormationConfig;
import com.huawei.dws.pbq.api.request.StatementQuery;
import com.huawei.dws.pbq.api.response.AsyncQueryResponse;
import com.huawei.dws.pbq.api.response.StatementResponse;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.postgresql.PGProperty;
import org.postgresql.core.BaseQueryKey;
import org.postgresql.core.CachedQuery;
import org.postgresql.core.CachedQueryCreateAction;
import org.postgresql.core.CallableQueryKey;
import org.postgresql.core.NativeQuery;
import org.postgresql.core.ParameterList;
import org.postgresql.core.Parser;
import org.postgresql.core.Query;
import org.postgresql.core.QueryWithReturningColumnsKey;
import org.postgresql.core.SqlCommand;
import org.postgresql.core.SqlCommandType;
import org.postgresql.core.TransactionState;
import org.postgresql.core.v3.BatchedQuery;
import org.postgresql.core.v3.CompositeQuery;
import org.postgresql.core.v3.ConnectionFactoryImpl;
import org.postgresql.core.v3.QueryExecutorImpl;
import org.postgresql.core.v3.SimpleParameterList;
import org.postgresql.core.v3.SimpleQuery;
import org.postgresql.core.v3.TypeTransferModeRegistry;
import org.postgresql.core.v3.V3ParameterList;
import org.postgresql.jdbc.EscapeSyntaxCallMode;
import org.postgresql.jdbc.PbqStatementResultHandler;
import org.postgresql.jdbc.PreferQueryMode;
import org.postgresql.jdbc.TimestampUtils;
import org.postgresql.util.GT;
import org.postgresql.util.LruCache;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class PbqExecutor
implements TypeTransferModeRegistry {
    private static final Logger LOGGER = Logger.getLogger(QueryExecutorImpl.class.getName());
    private String sessionId;
    private String workspaceId;
    private String endpointId;
    private DwsRestClient dwsRestClient;
    private String statementId;
    private String catalog;
    private String PGRES_FATAL_ERROR = "PGRES_FATAL_ERROR";
    private String PGRES_BAD_RESPONSE = "PGRES_BAD_RESPONSE";
    private static int FAILED = -1;
    private int SUCCESSFUL = 0;
    private int RUNNING = 1;
    private int EMPTY = 2;
    private int WAITING = 3;
    private boolean closed = false;
    private boolean multiFunctionSplit = false;
    private String RESULT_SET_FETCH_MODE_OBS = "OBS";
    private String RESULT_SET_FETCH_MODE_FABRIC = "FABRIC";
    private String resultSetFetchMode;
    private boolean fabricSqlAsyncQuery;
    private TransactionState transactionState = TransactionState.IDLE;
    private final LruCache<Object, CachedQuery> statementCache;
    private final CachedQueryCreateAction cachedQueryCreateAction;
    private final PreferQueryMode preferQueryMode;
    private final boolean reWriteBatchedInserts;
    private TimeZone timeZone;
    private Map<String, String> headers = new HashMap<String, String>();
    private final SimpleQuery emptyQuery = new SimpleQuery(new NativeQuery("", new int[0], false, SqlCommand.createStatementTypeInfo(SqlCommandType.BLANK)), null, false);
    private final int[] RETRY_PATTERN = new int[]{1, 1, 1, 1, 1};
    private final int RETRY_MAX_INDEX = this.RETRY_PATTERN.length - 1;

    public PbqExecutor(DwsRestClient restClient, String workspaceId, String catalog, Properties info) throws DwsApiException, PSQLException {
        String projectId;
        String host;
        String xAuthToken = PGProperty.X_AUTH_TOKEN.get(info);
        if (xAuthToken != null && !xAuthToken.trim().isEmpty()) {
            this.headers.put("X-Auth-Token", xAuthToken);
        }
        if ((host = PGProperty.FABRIC_EP_HOST.get(info)) != null && !host.trim().isEmpty()) {
            this.headers.put("HOST", host);
        }
        if ((projectId = PGProperty.PROJECT_ID.get(info)) != null && !projectId.trim().isEmpty()) {
            this.headers.put("X-Project-Id", projectId);
        }
        this.resultSetFetchMode = PGProperty.RESULT_SET_FETCH_MODE.get(info);
        this.fabricSqlAsyncQuery = PGProperty.FABRIC_SQL_ASYNC_QUERY.getBoolean(info);
        this.dwsRestClient = restClient;
        this.workspaceId = workspaceId;
        this.catalog = catalog;
        this.endpointId = PGProperty.ENDPOINT_ID.get(info);
        String lakeformationInstanceId = PGProperty.LAKEFORMATION_INSTANCE_ID.get(info);
        CreateSessionRequest request = new CreateSessionRequest();
        LakeFormationConfig lakeFormationConfig = new LakeFormationConfig();
        lakeFormationConfig.setInstanceId(lakeformationInstanceId);
        lakeFormationConfig.setCatalog(catalog);
        request.setLakeFormationConfig(lakeFormationConfig);
        request.setEndpointId(this.endpointId);
        this.sessionId = this.dwsRestClient.createSession(workspaceId, request, this.headers);
        this.reWriteBatchedInserts = PGProperty.REWRITE_BATCHED_INSERTS.getBoolean(info);
        String preferMode = PGProperty.PREFER_QUERY_MODE.get(info);
        this.preferQueryMode = PreferQueryMode.of(preferMode);
        this.cachedQueryCreateAction = new CachedQueryCreateAction(this);
        this.multiFunctionSplit = PGProperty.MULTI_FUNCTION_SPLIT.getBoolean(info);
        this.statementCache = new LruCache<Object, CachedQuery>(Math.max(0, PGProperty.PREPARED_STATEMENT_CACHE_QUERIES.getInt(info)), Math.max(0, PGProperty.PREPARED_STATEMENT_CACHE_SIZE_MIB.getInt(info) * 1024 * 1024), false, this.cachedQueryCreateAction, new LruCache.EvictAction<CachedQuery>(){

            @Override
            public void evict(CachedQuery cachedQuery) throws SQLException {
                cachedQuery.query.close();
            }
        });
        String postgresTimeZone = ConnectionFactoryImpl.createPostgresTimeZone();
        this.timeZone = TimestampUtils.parseBackendTimeZone(postgresTimeZone);
    }

    public void executeQuery(String sql, PbqStatementResultHandler handler) throws PSQLException {
        StatementQuery statementQuery = new StatementQuery();
        statementQuery.setStatement(sql);
        statementQuery.setSessionId(this.sessionId);
        statementQuery.setEndpointId(this.endpointId);
        List<StatementResult> result = this.executeRun(statementQuery);
        handler.addResult(result);
    }

    public final Object createQueryKey(String sql, boolean escapeProcessing, boolean isParameterized, String ... columnNames) {
        Object key = columnNames == null || columnNames.length != 0 ? new QueryWithReturningColumnsKey(sql, isParameterized, escapeProcessing, columnNames) : (isParameterized ? sql : new BaseQueryKey(sql, false, escapeProcessing));
        return key;
    }

    public CachedQuery createQueryByKey(Object key) throws SQLException {
        return this.cachedQueryCreateAction.create(key);
    }

    public CachedQuery borrowQueryByKey(Object key) throws SQLException {
        return this.statementCache.borrow(key);
    }

    public CachedQuery borrowQuery(String sql) throws SQLException {
        return this.statementCache.borrow(sql);
    }

    public CachedQuery borrowCallableQuery(String sql) throws SQLException {
        return this.statementCache.borrow(new CallableQueryKey(sql));
    }

    public CachedQuery borrowReturningQuery(String sql, String[] columnNames) throws SQLException {
        return this.statementCache.borrow(new QueryWithReturningColumnsKey(sql, true, true, columnNames));
    }

    public void releaseQuery(CachedQuery cachedQuery) {
        this.statementCache.put(cachedQuery.key, cachedQuery);
    }

    public Query wrap(List<NativeQuery> queries) {
        if (queries.isEmpty()) {
            return this.emptyQuery;
        }
        if (queries.size() == 1) {
            NativeQuery firstQuery = queries.get(0);
            if (this.isReWriteBatchedInsertsEnabled() && firstQuery.getCommand().isBatchedReWriteCompatible()) {
                int valuesBraceOpenPosition = firstQuery.getCommand().getBatchRewriteValuesBraceOpenPosition();
                int valuesBraceClosePosition = firstQuery.getCommand().getBatchRewriteValuesBraceClosePosition();
                return new BatchedQuery(firstQuery, this, valuesBraceOpenPosition, valuesBraceClosePosition, this.isColumnSanitiserDisabled());
            }
            return new SimpleQuery(firstQuery, this, this.isColumnSanitiserDisabled());
        }
        SimpleQuery[] subqueries = new SimpleQuery[queries.size()];
        int[] offsets = new int[subqueries.length];
        int offset = 0;
        for (int i = 0; i < queries.size(); ++i) {
            NativeQuery nativeQuery = queries.get(i);
            offsets[i] = offset;
            subqueries[i] = new SimpleQuery(nativeQuery, this, this.isColumnSanitiserDisabled());
            offset += nativeQuery.bindPositions.length;
        }
        return new CompositeQuery(subqueries, offsets);
    }

    public ParameterList createFastpathParameters(int count) {
        return new SimpleParameterList(count, this);
    }

    public int getProtocolVersion() {
        return 0;
    }

    public String getDatabase() {
        return this.catalog;
    }

    public int getBackendPID() {
        return 0;
    }

    public void sendQueryCancel() throws SQLException {
        try {
            this.dwsRestClient.cancelExecute(this.workspaceId, this.sessionId, this.statementId, this.headers);
        }
        catch (DwsApiException e) {
            LOGGER.log(Level.FINEST, "Ignoring exception on cancel request:", e);
        }
    }

    public void close() {
        try {
            this.dwsRestClient.closeSession(this.workspaceId, this.sessionId, this.headers);
        }
        catch (DwsApiException e) {
            throw new RuntimeException(e);
        }
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public int getServerVersionNum() {
        return 0;
    }

    public synchronized void setTransactionState(TransactionState state) {
        this.transactionState = state;
    }

    public TransactionState getTransactionState() {
        return this.transactionState;
    }

    public boolean getStandardConformingStrings() {
        return true;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public boolean isColumnSanitiserDisabled() {
        return false;
    }

    public EscapeSyntaxCallMode getEscapeSyntaxCallMode() {
        return null;
    }

    public PreferQueryMode getPreferQueryMode() {
        return this.preferQueryMode;
    }

    public boolean getMultiFunctionSplit() {
        return this.multiFunctionSplit;
    }

    public void executeBatch(Query[] queries, ParameterList[] parameterLists, PbqStatementResultHandler resultHandler, Integer maxRows) throws SQLException {
        this.executeBatchInternal(queries[0], parameterLists, resultHandler, maxRows);
    }

    private void executeBatchInternal(Query query, ParameterList[] parameterLists, PbqStatementResultHandler resultHandler, Integer maxRows) throws SQLException {
        StatementQuery statementQuery = new StatementQuery();
        statementQuery.setStatement(query.getNativeSql());
        statementQuery.setSessionId(this.sessionId);
        statementQuery.setEndpointId(this.endpointId);
        if (parameterLists != null) {
            ArrayList params = new ArrayList();
            for (int i = 0; i < parameterLists.length; ++i) {
                ParameterList parameterList = parameterLists[i];
                ArrayList<String> bindings = new ArrayList<String>();
                for (int j = 0; j < parameterList.getParameterCount(); ++j) {
                    String string = parameterList.toSimpleString(j, this.getStandardConformingStrings());
                    bindings.add(string);
                }
                params.add(bindings);
            }
            statementQuery.setBindings(params);
        }
        List<StatementResult> results = this.executeRun(statementQuery);
        resultHandler.addResult(results);
    }

    public void execute(Query[] queries, ParameterList[] parameterLists, PbqStatementResultHandler resultHandler, Integer maxRows) throws SQLException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "  batch execute {0} queries", new Object[]{queries.length});
        }
        for (ParameterList parameterList : parameterLists) {
            if (parameterList == null) continue;
            ((V3ParameterList)parameterList).checkAllParametersSet();
        }
        for (int i = 0; i < queries.length; ++i) {
            Query query = queries[i];
            V3ParameterList parameters = (V3ParameterList)parameterLists[i];
            if (parameters == null) {
                parameters = SimpleQuery.NO_PARAMETERS;
            }
            this.execute(query, parameters, resultHandler, maxRows);
        }
    }

    public void execute(Query query, ParameterList parameters, PbqStatementResultHandler handler, Integer maxRows) throws SQLException {
        StatementQuery statementQuery = new StatementQuery();
        statementQuery.setStatement(query.getNativeSql());
        statementQuery.setSessionId(this.sessionId);
        statementQuery.setEndpointId(this.endpointId);
        statementQuery.setLimit(maxRows);
        if (parameters == null) {
            parameters = SimpleQuery.NO_PARAMETERS;
        }
        Query[] subqueries = query.getSubqueries();
        SimpleParameterList[] subparams = ((V3ParameterList)parameters).getSubparams();
        if (subqueries == null) {
            this.executeSimpleQuery((SimpleQuery)query, (SimpleParameterList)parameters, handler);
        } else {
            for (int i = 0; i < subqueries.length; ++i) {
                Query subquery = subqueries[i];
                SimpleParameterList subparam = null;
                if (subparams != null) {
                    subparam = subparams[i];
                }
                this.executeSimpleQuery((SimpleQuery)subquery, subparam, handler);
            }
        }
    }

    private void executeSimpleQuery(SimpleQuery query, SimpleParameterList parameterList, PbqStatementResultHandler handler) throws PSQLException {
        StatementQuery statementQuery = new StatementQuery();
        statementQuery.setStatement(query.getNativeSql());
        statementQuery.setSessionId(this.sessionId);
        statementQuery.setEndpointId(this.endpointId);
        if (parameterList != null) {
            ArrayList<String> bindings = new ArrayList<String>();
            for (int i = 0; i < parameterList.getParameterCount(); ++i) {
                String string = parameterList.getValues()[i].toString();
                bindings.add(string);
            }
            ArrayList<ArrayList<String>> params = new ArrayList<ArrayList<String>>();
            if (!bindings.isEmpty()) {
                params.add(bindings);
            }
            statementQuery.setBindings(params);
        }
        List<StatementResult> result = this.executeRun(statementQuery);
        handler.addResult(result);
    }

    private synchronized List<StatementResult> executeRun(StatementQuery statementQuery) throws PSQLException {
        try {
            StatementResponse statementResponse;
            if (this.fabricSqlAsyncQuery) {
                AsyncQueryResponse asyncQueryResponse = this.dwsRestClient.asyncQuery(this.workspaceId, statementQuery, this.headers);
                this.statementId = asyncQueryResponse.getStatementId();
                statementResponse = this.getStatementResponse(this.statementId, 1);
            } else {
                statementResponse = this.dwsRestClient.syncQuery(this.workspaceId, statementQuery, this.headers);
                this.statementId = statementResponse.getStatementId();
            }
            int retry = 0;
            while (statementResponse.getStatus() == this.RUNNING || statementResponse.getStatus() == this.WAITING) {
                try {
                    Thread.sleep(50L * (long)this.RETRY_PATTERN[retry]);
                    if (retry < this.RETRY_MAX_INDEX) {
                        ++retry;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                statementResponse = this.getStatementResponse(this.statementId, 1);
            }
            List results = statementResponse.getResults();
            this.checkResponseError(statementResponse, results);
            return results;
        }
        catch (Exception e) {
            LOGGER.log(Level.FINEST, "execute failed, sessionId={0}", new Object[]{this.sessionId});
            if (e.getMessage().contains("is closed")) {
                LOGGER.log(Level.WARNING, "session {1} is closed", this.sessionId);
                this.closed = true;
                throw new PSQLException("This connection has been closed.", PSQLState.CONNECTION_DOES_NOT_EXIST);
            }
            throw new PSQLException("sessionId " + this.sessionId + " : " + e.getMessage(), PSQLState.UNKNOWN_STATE);
        }
    }

    private void checkResponseError(StatementResponse statementResponse, List<StatementResult> results) throws PSQLException {
        if (statementResponse.getStatus() == FAILED) {
            for (StatementResult result : results) {
                if (!this.PGRES_FATAL_ERROR.equalsIgnoreCase(result.getStatus()) && !this.PGRES_BAD_RESPONSE.equalsIgnoreCase(result.getStatus())) continue;
                throw new PSQLException(GT.tr(result.getMessage(), new Object[0]), null);
            }
        }
        if (statementResponse.getStatus() == this.EMPTY) {
            throw new PSQLException(GT.tr("Database Internal Error : ", new Object[0]) + statementResponse, null);
        }
    }

    public List<StatementResult> getStatementResult(StatementResult statementResult) throws PSQLException {
        try {
            int nextPage = statementResult.getPageNo() + 1;
            StatementResponse statementResponse = this.getStatementResponse(statementResult.getStatementId(), nextPage);
            List results = statementResponse.getResults();
            this.checkResponseError(statementResponse, results);
            return results;
        }
        catch (DwsApiException e) {
            LOGGER.log(Level.FINEST, "get statement result failed, sessionId={0}", new Object[]{this.sessionId});
            throw new PSQLException("sessionId " + this.sessionId + " : " + e.getMessage(), PSQLState.UNKNOWN_STATE);
        }
    }

    private StatementResponse getStatementResponse(String statementId, int nextPage) throws DwsApiException {
        if (this.RESULT_SET_FETCH_MODE_OBS.equals(this.resultSetFetchMode)) {
            return this.dwsRestClient.getStatementResult(this.workspaceId, this.sessionId, statementId, nextPage, this.headers);
        }
        return this.dwsRestClient.getStatementResultDirect(this.workspaceId, this.sessionId, statementId, nextPage, this.headers, -1);
    }

    public Query createSimpleQuery(String sql) throws SQLException {
        List<NativeQuery> queries = Parser.parseJdbcSql(sql, this.getStandardConformingStrings(), false, true, this.isReWriteBatchedInsertsEnabled(), new String[0]);
        return this.wrap(queries);
    }

    public boolean isReWriteBatchedInsertsEnabled() {
        return this.reWriteBatchedInserts;
    }

    public final CachedQuery createQuery(String sql, boolean escapeProcessing, boolean isParameterized, String ... columnNames) throws SQLException {
        Object key = this.createQueryKey(sql, escapeProcessing, isParameterized, columnNames);
        return this.createQueryByKey(key);
    }

    public void abort() {
        try {
            this.dwsRestClient.closeSession(this.workspaceId, this.sessionId);
        }
        catch (DwsApiException dwsApiException) {
            // empty catch block
        }
        this.closed = true;
    }

    @Override
    public boolean useBinaryForSend(int oid) {
        return false;
    }

    @Override
    public boolean useBinaryForReceive(int oid) {
        return false;
    }
}

