/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;
import org.postgresql.Driver;
import org.postgresql.core.CachedQuery;
import org.postgresql.core.ParameterList;
import org.postgresql.core.Query;
import org.postgresql.core.v3.BatchedQuery;
import org.postgresql.jdbc.PayByQueryConnection;
import org.postgresql.jdbc.PbqStatement;
import org.postgresql.jdbc.TimestampUtils;
import org.postgresql.util.GT;
import org.postgresql.util.PGTime;
import org.postgresql.util.PGTimestamp;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class PbqPreparedStatement
extends PbqStatement
implements PreparedStatement {
    protected final CachedQuery preparedQuery;
    protected final ParameterList preparedParameters;
    private TimeZone defaultTimeZone;

    public PbqPreparedStatement(PayByQueryConnection connection, String sql) throws SQLException {
        this(connection, connection.borrowQuery(sql));
    }

    PbqPreparedStatement(PayByQueryConnection connection, CachedQuery query) {
        super(connection);
        this.preparedQuery = query;
        this.preparedParameters = this.preparedQuery.query.createParameterList();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.execute(this.preparedQuery, this.preparedParameters);
        return this.getResultSet();
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.execute(this.preparedQuery, this.preparedParameters);
        return this.getUpdateCount();
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.execute(this.preparedQuery, this.preparedParameters);
        return this.getLargeUpdateCount();
    }

    @Override
    public boolean execute() throws SQLException {
        return this.execute(this.preparedQuery, this.preparedParameters);
    }

    @Override
    public void addBatch() throws SQLException {
        ArrayList<ParameterList> batchParameters;
        this.checkClosed();
        ArrayList<Query> batchStatements = this.batchStatements;
        if (batchStatements == null) {
            this.batchStatements = batchStatements = new ArrayList<Query>();
        }
        if ((batchParameters = this.batchParameters) == null) {
            this.batchParameters = batchParameters = new ArrayList<ParameterList>();
        }
        batchParameters.add(this.preparedParameters.copy());
        Query query = this.preparedQuery.query;
        if (!(query instanceof BatchedQuery) || batchStatements.isEmpty()) {
            batchStatements.add(query);
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setString(parameterIndex, null);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setString(parameterIndex, String.valueOf(x));
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setString(parameterIndex, String.valueOf(x));
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setString(parameterIndex, String.valueOf(x));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setString(parameterIndex, String.valueOf(x));
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setString(parameterIndex, String.valueOf(x));
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setString(parameterIndex, String.valueOf(x));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setString(parameterIndex, String.valueOf(x));
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setString(parameterIndex, x.toPlainString());
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.setString(parameterIndex, x, this.connection.getStringVarcharFlag() ? 1043 : 0);
    }

    protected void setString(int parameterIndex, String x, int oid) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.preparedParameters.setNull(parameterIndex, oid);
        } else {
            this.bindString(parameterIndex, x, oid);
        }
    }

    private void bindString(int paramIndex, String s, int oid) throws SQLException {
        this.preparedParameters.setStringParameter(paramIndex, s, oid);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setBytes(int, byte[])");
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setString(parameterIndex, x.toString());
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setString(parameterIndex, x.toString());
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setString(parameterIndex, x.toString());
    }

    private void setCharacterStreamPost71(int parameterIndex, InputStream x, int length, String encoding) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 12);
            return;
        }
        if (length < 0) {
            throw new PSQLException(GT.tr("Invalid stream length {0}.", length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        try {
            int n;
            InputStreamReader inStream = new InputStreamReader(x, encoding);
            char[] chars = new char[length];
            int charsRead = 0;
            while ((n = inStream.read(chars, charsRead, length - charsRead)) != -1 && (charsRead += n) != length) {
            }
            this.setString(parameterIndex, new String(chars, 0, charsRead), 1043);
        }
        catch (UnsupportedEncodingException uee) {
            throw new PSQLException(GT.tr("The JVM claims not to support the {0} encoding.", encoding), PSQLState.UNEXPECTED_ERROR, (Throwable)uee);
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Provided InputStream failed.", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)ioe);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setCharacterStreamPost71(parameterIndex, x, length, "ASCII");
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setCharacterStreamPost71(parameterIndex, x, length, "UTF-8");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setBinaryStream(int, InputStream, int)");
    }

    @Override
    public void clearParameters() throws SQLException {
        this.preparedParameters.clear();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setObject");
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.setString(parameterIndex, x.toString());
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        if (reader == null) {
            this.setNull(parameterIndex, 12);
            return;
        }
        if (length < 0) {
            throw new PSQLException(GT.tr("Invalid stream length {0}.", length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.setString(parameterIndex, this.readerToString(reader, length));
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setRef(int,Ref)");
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setBlob(int,Blob)");
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 2005);
            return;
        }
        String str = x.getSubString(1L, (int)x.length());
        this.setString(parameterIndex, str, this.connection.getStringVarcharFlag() ? 1043 : 0);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        if (null == x) {
            this.setNull(parameterIndex, 2003);
            return;
        }
        String typename = x.getBaseTypeName();
        int oid = this.connection.getTypeInfo().getPGArrayType(typename);
        if (oid == 0) {
            throw new PSQLException(GT.tr("Unknown type {0}.", typename), PSQLState.INVALID_PARAMETER_TYPE);
        }
        this.setString(parameterIndex, x.toString(), oid);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSet rs = this.getResultSet();
        if (rs != null) {
            return rs.getMetaData();
        }
        return null;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        if (cal == null) {
            cal = this.getDefaultCalendar();
        }
        this.bindString(parameterIndex, this.connection.getTimestampUtils().toString(cal, x), 0);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 92);
            return;
        }
        int oid = 0;
        if (x instanceof PGTime) {
            PGTime pgTime = (PGTime)x;
            if (pgTime.getCalendar() == null) {
                oid = 1083;
            } else {
                oid = 1266;
                cal = pgTime.getCalendar();
            }
        }
        if (cal == null) {
            cal = this.getDefaultCalendar();
        }
        this.bindString(parameterIndex, this.connection.getTimestampUtils().toString(cal, x), oid);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 93);
            return;
        }
        int oid = 0;
        if (x instanceof PGTimestamp) {
            PGTimestamp pgTimestamp = (PGTimestamp)x;
            if (pgTimestamp.getCalendar() == null) {
                oid = 1114;
            } else {
                oid = 1184;
                cal = pgTimestamp.getCalendar();
            }
        }
        if (cal == null) {
            cal = this.getDefaultCalendar();
        }
        this.bindString(parameterIndex, this.connection.getTimestampUtils().toString(cal, x), oid);
    }

    private Calendar getDefaultCalendar() {
        TimestampUtils timestampUtils = this.connection.getTimestampUtils();
        if (timestampUtils.hasFastDefaultTimeZone()) {
            return timestampUtils.getSharedCalendar(null);
        }
        Calendar sharedCalendar = timestampUtils.getSharedCalendar(this.defaultTimeZone);
        if (this.defaultTimeZone == null) {
            this.defaultTimeZone = sharedCalendar.getTimeZone();
        }
        return sharedCalendar;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setString(parameterIndex, null);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setURL(int,URL)");
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getParameterMetaData()");
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setRowId(int, RowId)");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNString(int, String)");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNCharacterStream(int, Reader, long)");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNClob(int, NClob)");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        if (length < 0L) {
            throw new SQLException("parameter length can not be less than 0");
        }
        StringBuffer strbuf = new StringBuffer();
        char[] buf = new char[1024];
        int num = 0;
        Long count = 0L;
        try {
            while ((num = reader.read(buf)) != -1) {
                if (count + (long)num < length) {
                    strbuf.append(new String(buf, 0, num));
                    count = count + (long)num;
                    continue;
                }
                strbuf.append(new String(buf, 0, (int)(length - count)));
                count = length;
                break;
            }
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
        if (length == 0L) {
            this.setString(parameterIndex, "", this.connection.getStringVarcharFlag() ? 1043 : 0);
        }
        if (count != length) {
            throw new SQLException("parameter length can not be bigger than reader's length");
        }
        this.setString(parameterIndex, strbuf.toString(), this.connection.getStringVarcharFlag() ? 1043 : 0);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setBlob(int, InputStream, long)");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNClob(int, Reader, long)");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        String stringValue;
        String string = stringValue = xmlObject == null ? null : xmlObject.getString();
        if (stringValue == null) {
            this.setNull(parameterIndex, 2009);
        } else {
            this.setString(parameterIndex, stringValue, 142);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setObject");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setAsciiStream(int, InputStream, long)");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setBinaryStream(int, InputStream, long)");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setCharacterStream(int, Reader, long)");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setAsciiStream(int, InputStream)");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setBinaryStream(int, InputStream)");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setCharacterStream(int, Reader, long)");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNCharacterStream(int, Reader)");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        StringBuffer strbuf = new StringBuffer();
        char[] buf = new char[1024];
        int num = 0;
        try {
            while ((num = reader.read(buf)) != -1) {
                strbuf.append(new String(buf, 0, num));
            }
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
        this.setString(parameterIndex, strbuf.toString(), this.connection.getStringVarcharFlag() ? 1043 : 0);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setBlob(int, InputStream)");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNClob(int, Reader)");
    }

    private String readerToString(Reader value, int maxLength) throws SQLException {
        try {
            int bufferSize = Math.min(maxLength, 1024);
            StringBuilder v = new StringBuilder(bufferSize);
            char[] buf = new char[bufferSize];
            int nRead = 0;
            while (nRead > -1 && v.length() < maxLength) {
                nRead = value.read(buf, 0, Math.min(bufferSize, maxLength - v.length()));
                if (nRead <= 0) continue;
                v.append(buf, 0, nRead);
            }
            return v.toString();
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Provided Reader failed.", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)ioe);
        }
    }
}

