/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.ssl;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class CheckCertCrlTrustManager
implements X509TrustManager {
    X509TrustManager trustManager;
    String crlFilePath;

    public CheckCertCrlTrustManager(TrustManager trustManager, String crlFilePath) {
        this.trustManager = (X509TrustManager)trustManager;
        this.crlFilePath = crlFilePath;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        this.checkCertRevoked(chain, cf);
        this.trustManager.checkServerTrusted(chain, authType);
    }

    private void checkCertRevoked(X509Certificate[] chain, CertificateFactory cf) throws CertificateException {
        if (chain == null || chain.length == 0) {
            return;
        }
        if (cf == null) {
            return;
        }
        if (this.crlFilePath == null || "".equals(this.crlFilePath)) {
            return;
        }
        X509CRL crl = null;
        try {
            FileInputStream fis = new FileInputStream(this.crlFilePath);
            crl = (X509CRL)cf.generateCRL(fis);
            fis.close();
        }
        catch (FileNotFoundException | CRLException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (X509Certificate cert : chain) {
            boolean revoked = crl.isRevoked(cert);
            if (!revoked) continue;
            throw new CertificateException("this cert is revoked.");
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }
}

