/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss200.jdbc.core;

import com.huawei.gauss200.jdbc.core.OptimizedUTF8Encoder;
import java.io.IOException;
import java.nio.charset.Charset;

final class ByteOptimizedUTF8Encoder
extends OptimizedUTF8Encoder {
    private static final Charset ASCII_CHARSET = Charset.forName("ascii");

    ByteOptimizedUTF8Encoder() {
    }

    @Override
    public String decode(byte[] encodedString, int offset, int length) throws IOException {
        if (length <= 32) {
            return this.charDecode(encodedString, offset, length);
        }
        int j = offset + length;
        for (int i = offset; i < j; ++i) {
            if (encodedString[i] >= 0) continue;
            return this.slowDecode(encodedString, offset, length, i);
        }
        return new String(encodedString, offset, length, ASCII_CHARSET);
    }

    private synchronized String slowDecode(byte[] encodedString, int offset, int length, int curIdx) throws IOException {
        char[] chars = this.getCharArray(length);
        int out = 0;
        for (int i = offset; i < curIdx; ++i) {
            chars[out++] = (char)encodedString[i];
        }
        return ByteOptimizedUTF8Encoder.decodeToChars(encodedString, curIdx, length - (curIdx - offset), chars, out);
    }
}

