/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss200.jdbc.core;

import com.huawei.gauss200.jdbc.core.BaseQueryKey;
import com.huawei.gauss200.jdbc.core.CachedQuery;
import com.huawei.gauss200.jdbc.core.CallableQueryKey;
import com.huawei.gauss200.jdbc.core.JdbcCallParseInfo;
import com.huawei.gauss200.jdbc.core.NativeQuery;
import com.huawei.gauss200.jdbc.core.Parser;
import com.huawei.gauss200.jdbc.core.PbqExecutor;
import com.huawei.gauss200.jdbc.core.Query;
import com.huawei.gauss200.jdbc.core.QueryExecutor;
import com.huawei.gauss200.jdbc.core.QueryWithReturningColumnsKey;
import com.huawei.gauss200.jdbc.jdbc.EscapeSyntaxCallMode;
import com.huawei.gauss200.jdbc.jdbc.PreferQueryMode;
import com.huawei.gauss200.jdbc.util.LruCache;
import com.huawei.gauss200.jdbc.util.internal.Nullness;
import java.sql.SQLException;
import java.util.List;

public class CachedQueryCreateAction
implements LruCache.CreateAction<Object, CachedQuery> {
    private static final String[] EMPTY_RETURNING = new String[0];
    private final QueryExecutor queryExecutor;
    private final PbqExecutor pbqExecutor;
    private final PreferQueryMode preferQueryMode;
    private final boolean multiFunctionSplit;

    CachedQueryCreateAction(QueryExecutor queryExecutor) {
        this.queryExecutor = queryExecutor;
        this.pbqExecutor = null;
        this.preferQueryMode = queryExecutor.getPreferQueryMode();
        this.multiFunctionSplit = queryExecutor.getMultiFunctionSplit();
    }

    public CachedQueryCreateAction(PbqExecutor queryExecutor) {
        this.pbqExecutor = queryExecutor;
        this.queryExecutor = null;
        this.preferQueryMode = queryExecutor.getPreferQueryMode();
        this.multiFunctionSplit = queryExecutor.getMultiFunctionSplit();
    }

    private int getProtocolVersion() {
        if (this.queryExecutor != null) {
            return this.queryExecutor.getProtocolVersion();
        }
        return this.pbqExecutor.getProtocolVersion();
    }

    private EscapeSyntaxCallMode getEscapeSyntaxCallMode() {
        if (this.queryExecutor != null) {
            return this.queryExecutor.getEscapeSyntaxCallMode();
        }
        return this.pbqExecutor.getEscapeSyntaxCallMode();
    }

    private boolean getStandardConformingStrings() {
        if (this.queryExecutor != null) {
            return this.queryExecutor.getStandardConformingStrings();
        }
        return this.pbqExecutor.getStandardConformingStrings();
    }

    private boolean isReWriteBatchedInsertsEnabled() {
        if (this.queryExecutor != null) {
            return this.queryExecutor.isReWriteBatchedInsertsEnabled();
        }
        return this.pbqExecutor.isReWriteBatchedInsertsEnabled();
    }

    private int getServerVersionNum() {
        if (this.queryExecutor != null) {
            return this.queryExecutor.getServerVersionNum();
        }
        return this.pbqExecutor.getServerVersionNum();
    }

    private Query wrap(List<NativeQuery> queries) {
        if (this.queryExecutor != null) {
            return this.queryExecutor.wrap(queries);
        }
        return this.pbqExecutor.wrap(queries);
    }

    @Override
    public CachedQuery create(Object key) throws SQLException {
        boolean isFunction;
        String parsedSql;
        BaseQueryKey queryKey;
        assert (key instanceof String || key instanceof BaseQueryKey) : "Query key should be String or BaseQueryKey. Given " + key.getClass() + ", sql: " + key;
        if (key instanceof BaseQueryKey) {
            queryKey = (BaseQueryKey)key;
            parsedSql = queryKey.sql;
        } else {
            queryKey = null;
            parsedSql = (String)key;
        }
        if (key instanceof String || Nullness.castNonNull(queryKey).escapeProcessing) {
            parsedSql = Parser.replaceProcessing(parsedSql, true, this.getStandardConformingStrings());
        }
        if (key instanceof CallableQueryKey) {
            JdbcCallParseInfo callInfo = Parser.modifyJdbcCall(parsedSql, this.getStandardConformingStrings(), this.getServerVersionNum(), this.getProtocolVersion(), this.getEscapeSyntaxCallMode());
            parsedSql = callInfo.getSql();
            isFunction = callInfo.isFunction();
        } else {
            isFunction = false;
        }
        boolean isParameterized = key instanceof String || Nullness.castNonNull(queryKey).isParameterized;
        boolean splitStatements = isParameterized || this.preferQueryMode.compareTo(PreferQueryMode.EXTENDED) >= 0;
        String[] returningColumns = key instanceof QueryWithReturningColumnsKey ? ((QueryWithReturningColumnsKey)key).columnNames : EMPTY_RETURNING;
        List<NativeQuery> queries = Parser.parseJdbcSql(parsedSql, this.getStandardConformingStrings(), isParameterized, splitStatements, this.isReWriteBatchedInsertsEnabled(), this.multiFunctionSplit, returningColumns);
        Query query = this.wrap(queries);
        return new CachedQuery(key, query, isFunction);
    }
}

