/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss200.jdbc.jdbc;

import com.huawei.dws.pbq.api.DwsRestClient;
import com.huawei.dws.pbq.api.exception.DwsApiException;
import com.huawei.gauss200.jdbc.Driver;
import com.huawei.gauss200.jdbc.PGProperty;
import com.huawei.gauss200.jdbc.core.CachedQuery;
import com.huawei.gauss200.jdbc.core.Encoding;
import com.huawei.gauss200.jdbc.core.PbqExecutor;
import com.huawei.gauss200.jdbc.core.Query;
import com.huawei.gauss200.jdbc.core.TransactionState;
import com.huawei.gauss200.jdbc.core.TypeInfo;
import com.huawei.gauss200.jdbc.core.Utils;
import com.huawei.gauss200.jdbc.core.Version;
import com.huawei.gauss200.jdbc.core.types.PGBlob;
import com.huawei.gauss200.jdbc.core.types.PGClob;
import com.huawei.gauss200.jdbc.jdbc.PSQLSavepoint;
import com.huawei.gauss200.jdbc.jdbc.PbqCallableStatement;
import com.huawei.gauss200.jdbc.jdbc.PbqDatabaseMetadata;
import com.huawei.gauss200.jdbc.jdbc.PbqPreparedStatement;
import com.huawei.gauss200.jdbc.jdbc.PbqStatement;
import com.huawei.gauss200.jdbc.jdbc.PbqStatementResultHandler;
import com.huawei.gauss200.jdbc.jdbc.PreferQueryMode;
import com.huawei.gauss200.jdbc.jdbc.TimestampUtils;
import com.huawei.gauss200.jdbc.jdbc.TypeInfoCache;
import com.huawei.gauss200.jdbc.util.GT;
import com.huawei.gauss200.jdbc.util.HostSpec;
import com.huawei.gauss200.jdbc.util.PSQLException;
import com.huawei.gauss200.jdbc.util.PSQLState;
import java.io.IOException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class PayByQueryConnection
implements Connection {
    private static final Logger LOGGER = Logger.getLogger(PayByQueryConnection.class.getName());
    private final DwsRestClient dwsRestClient;
    private static final String IPV4_REGEX = "^((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$";
    private PbqExecutor executor;
    private boolean autoCommit = true;
    private final CachedQuery setSessionReadOnly;
    private final CachedQuery setSessionNotReadOnly;
    protected Map<String, Class<?>> typemap = new HashMap();
    private boolean readOnly = false;
    private final Query commitQuery;
    private final Query rollbackQuery;
    private Properties info;
    private int savepointId = 0;
    private final TypeInfo typeCache;
    private volatile Timer cancelTimer;
    private boolean autoReConnection = false;
    public boolean batchInsert = true;
    public String catalog;
    public boolean disableColumnSanitiser = true;
    public boolean bindStringAsVarchar = false;
    private PreparedStatement checkConnectionQuery;
    private final TimestampUtils timestampUtils;
    private int autoReConnectCount = 0;
    protected DatabaseMetaData metadata;
    private final String creatingURL;

    public DwsRestClient getDwsRestClient() {
        return this.dwsRestClient;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PayByQueryConnection(HostSpec hostSpecs, String catalog, Properties info, String url) throws SQLException {
        String batchString;
        String ak = PGProperty.ACCESS_KEY_ID.get(info);
        String sk = PGProperty.SECRET_ACCESS_KEY.get(info);
        String securityToken = PGProperty.SECURITY_TOKEN.get(info);
        String workspaceId = PGProperty.WORKSPACE_ID.get(info);
        String endpoint = hostSpecs.toString();
        if (!Pattern.matches(IPV4_REGEX, hostSpecs.getHost())) {
            endpoint = hostSpecs.getHost();
        }
        this.creatingURL = url;
        this.catalog = catalog;
        this.dwsRestClient = new DwsRestClient(endpoint, ak, sk, securityToken);
        try {
            this.executor = new PbqExecutor(this.dwsRestClient, workspaceId, catalog, info);
        }
        catch (DwsApiException e) {
            throw new PSQLException(GT.tr("Create pay by query connection failed: {0}", new Object[]{e}), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.setSessionReadOnly = this.createQuery("SET SESSION CHARACTERISTICS AS TRANSACTION READ ONLY", false, true, new String[0]);
        this.setSessionNotReadOnly = this.createQuery("SET SESSION CHARACTERISTICS AS TRANSACTION READ WRITE", false, true, new String[0]);
        this.commitQuery = this.createQuery((String)"COMMIT", (boolean)false, (boolean)true, (String[])new String[0]).query;
        this.rollbackQuery = this.createQuery((String)"ROLLBACK", (boolean)false, (boolean)true, (String[])new String[0]).query;
        if (PGProperty.AUTO_RECONNECT.getBoolean(info)) {
            this.autoReConnection = true;
            this.autoReConnectCount = PGProperty.RECONNECT_COUNT.getInt(info);
        }
        if ((batchString = info.getProperty("batchMode")) == null) {
            this.batchInsert = true;
        } else if (batchString.equalsIgnoreCase("OFF")) {
            this.batchInsert = false;
        } else if (batchString.equalsIgnoreCase("ON")) {
            this.batchInsert = true;
        }
        String stringType = PGProperty.STRING_TYPE.get(info);
        if (stringType != null) {
            if (stringType.equalsIgnoreCase("unspecified")) {
                this.bindStringAsVarchar = false;
            } else {
                if (!stringType.equalsIgnoreCase("varchar")) throw new PSQLException(GT.tr("Unsupported value for stringtype parameter: {0}", stringType), PSQLState.INVALID_PARAMETER_VALUE);
                this.bindStringAsVarchar = true;
            }
        } else {
            this.bindStringAsVarchar = true;
        }
        this.timestampUtils = new TimestampUtils(true, () -> this.executor.getTimeZone());
        this.disableColumnSanitiser = PGProperty.DISABLE_COLUMN_SANITISER.getBoolean(info);
        int unknownLength = PGProperty.UNKNOWN_LENGTH.getInt(info);
        this.typeCache = new TypeInfoCache(this, unknownLength);
        this.info = info;
    }

    public void cancelQuery() throws SQLException {
        this.executor.sendQueryCancel();
    }

    public String getURL() throws SQLException {
        return this.creatingURL;
    }

    public PreferQueryMode getPreferQueryMode() {
        return this.executor.getPreferQueryMode();
    }

    public ResultSet execSQLQuery(String sql) throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery(sql);
        statement.close();
        return resultSet;
    }

    public void execSQLUpdate(String sql) throws SQLException {
        Statement statement = this.createStatement();
        statement.execute(sql);
        statement.close();
    }

    void execSQLUpdate(CachedQuery query) throws SQLException {
        PbqStatement stmt = (PbqStatement)this.createStatement();
        stmt.execute(query);
        stmt.close();
    }

    public TypeInfo getTypeInfo() {
        return this.typeCache;
    }

    public boolean haveMinimumServerVersion(Version ver) {
        return false;
    }

    public TimestampUtils getTimestampUtils() {
        return this.timestampUtils;
    }

    public boolean getStringVarcharFlag() {
        return this.bindStringAsVarchar;
    }

    public boolean isColumnSanitiserDisabled() {
        return this.disableColumnSanitiser;
    }

    private synchronized Timer getTimer() {
        if (this.cancelTimer == null) {
            this.cancelTimer = Driver.getSharedTimer().getTimer();
        }
        return this.cancelTimer;
    }

    private synchronized void releaseTimer() {
        TimerTask timerTask = Driver.getTimerTask();
        if (timerTask != null) {
            timerTask.cancel();
            timerTask = null;
        }
        Driver.getTimerIsCalled().compareAndSet(true, false);
        if (this.cancelTimer != null) {
            this.cancelTimer = null;
            Driver.getSharedTimer().releaseTimer();
        }
    }

    public void addTimerTask(TimerTask timerTask, long milliSeconds) {
        Timer timer = this.getTimer();
        timer.schedule(timerTask, milliSeconds);
    }

    public void purgeTimerTasks() {
        Timer timer = this.cancelTimer;
        if (timer != null) {
            timer.purge();
        }
    }

    public CachedQuery createQuery(String sql, boolean escapeProcessing, boolean isParameterized, String ... columnNames) throws SQLException {
        return this.executor.createQuery(sql, escapeProcessing, isParameterized, columnNames);
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkClosed();
        return new PbqStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new PbqPreparedStatement(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return new PbqCallableStatement(this, sql);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        CachedQuery cachedQuery = this.executor.createQuery(sql, false, true, new String[0]);
        return cachedQuery.query.getNativeSql();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.autoCommit == autoCommit) {
            return;
        }
        if (!this.autoCommit) {
            this.commit();
        }
        if (this.readOnly) {
            if (autoCommit) {
                this.autoCommit = true;
                this.execSQLUpdate(this.setSessionReadOnly);
            } else {
                this.execSQLUpdate(this.setSessionNotReadOnly);
            }
        }
        this.autoCommit = autoCommit;
        LOGGER.log(Level.FINE, "  setAutoCommit = {0}", autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    @Override
    public void commit() throws SQLException {
        if (this.autoCommit) {
            throw new PSQLException(GT.tr("Cannot commit when autoCommit is enabled.", new Object[0]), PSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        if (this.executor.getTransactionState() != TransactionState.IDLE) {
            this.executeTransactionCommand(this.commitQuery);
        }
    }

    private void executeTransactionCommand(Query query) throws SQLException {
        try {
            this.getExecutor().execute(query, null, new PbqStatementResultHandler(), null);
        }
        catch (SQLException e) {
            if (query.getSubqueries() != null) {
                throw e;
            }
            query.close();
            this.getExecutor().execute(query, null, new PbqStatementResultHandler(), null);
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.checkClosed();
        if (this.autoCommit) {
            throw new PSQLException(GT.tr("Cannot rollback when autoCommit is enabled.", new Object[0]), PSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        if (this.executor.getTransactionState() != TransactionState.IDLE) {
            this.executeTransactionCommand(this.rollbackQuery);
        } else {
            LOGGER.log(Level.FINE, "Rollback requested but no transaction in progress");
        }
    }

    @Override
    public void close() throws SQLException {
        this.executor.close();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.executor.isClosed();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void checkClosed() throws SQLException {
        if (!this.isClosed()) return;
        if (!this.autoReConnection) throw new PSQLException(GT.tr("This connection has been closed.", new Object[0]), PSQLState.CONNECTION_DOES_NOT_EXIST);
        int reConnectCount = this.autoReConnectCount;
        PbqExecutor pbqExecutor = null;
        DwsApiException ex = null;
        for (int i = 0; i < reConnectCount; ++i) {
            try {
                String workspaceId = PGProperty.WORKSPACE_ID.get(this.info);
                pbqExecutor = new PbqExecutor(this.dwsRestClient, workspaceId, this.catalog, this.info);
            }
            catch (DwsApiException e) {
                ex = e;
                continue;
            }
            if (pbqExecutor != null) break;
        }
        if (pbqExecutor == null) throw new PSQLException(GT.tr("try reconnection has been fail.", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)ex);
        this.executor = pbqExecutor;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.metadata == null) {
            this.metadata = new PbqDatabaseMetadata(this);
        }
        return this.metadata;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (readOnly != this.readOnly && this.autoCommit) {
            this.execSQLUpdate(readOnly ? this.setSessionReadOnly : this.setSessionNotReadOnly);
        }
        this.readOnly = readOnly;
        LOGGER.log(Level.FINE, "  setReadOnly = {0}", readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkClosed();
        return this.readOnly;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.executor.getDatabase();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        if (this.executor.getTransactionState() != TransactionState.IDLE) {
            throw new PSQLException(GT.tr("Cannot change transaction isolation level in the middle of a transaction.", new Object[0]), PSQLState.ACTIVE_SQL_TRANSACTION);
        }
        String isolationLevelName = this.getIsolationLevelName(level);
        if (isolationLevelName == null) {
            throw new PSQLException(GT.tr("Transaction isolation level {0} not supported.", level), PSQLState.NOT_IMPLEMENTED);
        }
        String isolationLevelSQL = "SET SESSION CHARACTERISTICS AS TRANSACTION ISOLATION LEVEL " + isolationLevelName;
        this.execSQLUpdate(isolationLevelSQL);
        LOGGER.log(Level.FINE, "  setTransactionIsolation = {0}", isolationLevelName);
    }

    protected String getIsolationLevelName(int level) {
        switch (level) {
            case 2: {
                return "READ COMMITTED";
            }
            case 8: {
                return "SERIALIZABLE";
            }
            case 1: {
                return "READ UNCOMMITTED";
            }
            case 4: {
                return "REPEATABLE READ";
            }
        }
        return null;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        String level = null;
        ResultSet rs = this.execSQLQuery("SHOW TRANSACTION ISOLATION LEVEL");
        if (rs.next()) {
            level = rs.getString(1);
        }
        rs.close();
        if (level == null) {
            return 2;
        }
        if ((level = level.toUpperCase(Locale.US)).equals("READ COMMITTED")) {
            return 2;
        }
        if (level.equals("READ UNCOMMITTED")) {
            return 1;
        }
        if (level.equals("REPEATABLE READ")) {
            return 4;
        }
        if (level.equals("SERIALIZABLE")) {
            return 8;
        }
        return 2;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new PbqStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new PbqPreparedStatement(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new PbqCallableStatement(this, sql);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.typemap;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.typemap = map;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        if (holdability != 1) {
            throw new PSQLException(GT.tr("Unknown ResultSet holdability setting: {0}.", holdability), PSQLState.INVALID_PARAMETER_VALUE);
        }
        LOGGER.log(Level.FINE, "  setHoldability = {0}", holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkClosed();
        if (this.getAutoCommit()) {
            throw new PSQLException(GT.tr("Cannot establish a savepoint in auto-commit mode.", new Object[0]), PSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        PSQLSavepoint savepoint = new PSQLSavepoint(this.savepointId++);
        String pgName = savepoint.getPGName();
        Statement stmt = this.createStatement();
        stmt.executeUpdate("SAVEPOINT " + pgName);
        stmt.close();
        return savepoint;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkClosed();
        if (this.getAutoCommit()) {
            throw new PSQLException(GT.tr("Cannot establish a savepoint in auto-commit mode.", new Object[0]), PSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        PSQLSavepoint savepoint = new PSQLSavepoint(name);
        Statement stmt = this.createStatement();
        stmt.executeUpdate("SAVEPOINT " + savepoint.getPGName());
        stmt.close();
        return savepoint;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        PSQLSavepoint pgSavepoint = (PSQLSavepoint)savepoint;
        this.execSQLUpdate("ROLLBACK TO SAVEPOINT " + pgSavepoint.getPGName());
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        PSQLSavepoint pgSavepoint = (PSQLSavepoint)savepoint;
        this.execSQLUpdate("RELEASE SAVEPOINT " + pgSavepoint.getPGName());
        pgSavepoint.invalidate();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new PbqStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new PbqPreparedStatement(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new PbqCallableStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new PSQLException(GT.tr("Returning keys is not supported.", new Object[0]), PSQLState.NOT_IMPLEMENTED);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new PSQLException(GT.tr("Returning keys is not supported.", new Object[0]), PSQLState.NOT_IMPLEMENTED);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new PSQLException(GT.tr("Returning keys is not supported.", new Object[0]), PSQLState.NOT_IMPLEMENTED);
    }

    @Override
    public Clob createClob() throws SQLException {
        return new PGClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return new PGBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw Driver.notImplemented(this.getClass(), "createNClob()");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw Driver.notImplemented(this.getClass(), "createSQLXML()");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new PSQLException(GT.tr("Invalid timeout ({0}<0).", timeout), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (this.isClosed()) {
            return false;
        }
        try {
            this.checkConnectionQuery = this.prepareStatement("select 1;");
            this.checkConnectionQuery.setQueryTimeout(timeout);
            this.checkConnectionQuery.executeUpdate();
            return true;
        }
        catch (SQLException e) {
            if (PSQLState.IN_FAILED_SQL_TRANSACTION.getState().equals(e.getSQLState())) {
                return true;
            }
            LOGGER.log(Level.FINE, GT.tr("Validating connection.", new Object[0]), e);
            return false;
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getClientInfo(String, Object[])");
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "createArrayOf(String, Object[])");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "createStruct(String, Object[])");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkClosed();
        try (Statement stmt = this.createStatement();){
            if (schema == null) {
                stmt.executeUpdate("SET SESSION search_path TO DEFAULT");
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("SET SESSION search_path TO '");
                Utils.escapeLiteral(sb, schema, false);
                sb.append("'");
                stmt.executeUpdate(sb.toString());
                LOGGER.log(Level.FINE, "  setSchema = {0}", schema);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSchema() throws SQLException {
        try (Statement stmt = this.createStatement();){
            ResultSet rs;
            block8: {
                String string;
                rs = stmt.executeQuery("select pg_catalog.current_schema()");
                try {
                    if (rs.next()) break block8;
                    string = null;
                }
                catch (Throwable throwable) {
                    rs.close();
                    throw throwable;
                }
                rs.close();
                return string;
            }
            String string = rs.getString(1);
            rs.close();
            return string;
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (executor == null) {
            throw new SQLException("executor is null");
        }
        if (this.isClosed()) {
            return;
        }
        executor.execute(() -> this.executor.abort());
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new PSQLException(GT.tr("setNetworkTimeout is not supported.", new Object[0]), PSQLState.NOT_IMPLEMENTED);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    public PbqExecutor getExecutor() {
        return this.executor;
    }

    final CachedQuery borrowQuery(String sql) throws SQLException {
        return this.executor.borrowQuery(sql);
    }

    final CachedQuery borrowCallableQuery(String sql) throws SQLException {
        return this.executor.borrowCallableQuery(sql);
    }

    public boolean isBatchInsert() {
        return this.batchInsert;
    }

    public String escapeString(String str) throws SQLException {
        return Utils.escapeLiteral(null, str, this.executor.getStandardConformingStrings()).toString();
    }

    public boolean getStandardConformingStrings() {
        return this.executor.getStandardConformingStrings();
    }

    public byte[] encodeString(String str) throws SQLException {
        try {
            return Encoding.getJVMEncoding("UTF-8").encode(str);
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Unable to translate data into the desired encoding.", new Object[0]), PSQLState.DATA_ERROR, (Throwable)ioe);
        }
    }
}

