/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss200.jdbc.jdbc;

import com.huawei.gauss200.jdbc.Driver;
import com.huawei.gauss200.jdbc.core.CachedQuery;
import com.huawei.gauss200.jdbc.core.ParameterList;
import com.huawei.gauss200.jdbc.core.PbqExecutor;
import com.huawei.gauss200.jdbc.core.Query;
import com.huawei.gauss200.jdbc.jdbc.PayByQueryConnection;
import com.huawei.gauss200.jdbc.jdbc.PbqStatementResultHandler;
import com.huawei.gauss200.jdbc.jdbc.PreferQueryMode;
import com.huawei.gauss200.jdbc.jdbc.StatementCancelState;
import com.huawei.gauss200.jdbc.util.GT;
import com.huawei.gauss200.jdbc.util.PSQLException;
import com.huawei.gauss200.jdbc.util.PSQLState;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class PbqStatement
implements Statement {
    protected final PayByQueryConnection connection;
    private volatile boolean isClosed = false;
    private PbqStatementResultHandler resultHandler;
    private static final String[] NO_RETURNING_COLUMNS = new String[0];
    protected int fetchdirection = 1000;
    protected ArrayList<Query> batchStatements = null;
    protected ArrayList<ParameterList> batchParameters = null;
    protected boolean replaceProcessingEnabled = true;
    private boolean closeOnCompletion = false;
    protected Integer maxRows;
    protected int maxFieldSize = 0;
    private volatile StatementCancelState statementState = StatementCancelState.IDLE;
    private static final AtomicReferenceFieldUpdater<PbqStatement, StatementCancelState> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(PbqStatement.class, StatementCancelState.class, "statementState");
    protected long timeout = 0L;
    private volatile TimerTask cancelTimerTask = null;
    private static final AtomicReferenceFieldUpdater<PbqStatement, TimerTask> CANCEL_TIMER_UPDATER = AtomicReferenceFieldUpdater.newUpdater(PbqStatement.class, TimerTask.class, "cancelTimerTask");

    public PbqStatement(PayByQueryConnection connection) {
        this.connection = connection;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.executeCachedSql(sql, NO_RETURNING_COLUMNS);
        return this.getResultSet();
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.executeCachedSql(sql, NO_RETURNING_COLUMNS);
        return this.getUpdateCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeCachedSql(String sql, String[] columnNames) throws SQLException {
        boolean res;
        PreferQueryMode preferQueryMode = this.connection.getPreferQueryMode();
        boolean shouldUseParameterized = false;
        PbqExecutor queryExecutor = this.connection.getExecutor();
        Object key = queryExecutor.createQueryKey(sql, this.replaceProcessingEnabled, shouldUseParameterized, columnNames);
        boolean shouldCache = preferQueryMode == PreferQueryMode.EXTENDED_CACHE_EVERYTHING;
        CachedQuery cachedQuery = shouldCache ? queryExecutor.borrowQueryByKey(key) : queryExecutor.createQueryByKey(key);
        try {
            res = this.execute(cachedQuery);
        }
        finally {
            if (shouldCache) {
                queryExecutor.releaseQuery(cachedQuery);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        PbqStatement pbqStatement = this;
        synchronized (pbqStatement) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }
        this.cancel();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkClosed();
        if (max < 0) {
            throw new PSQLException(GT.tr("The maximum field size must be a value greater than or equal to 0.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.maxFieldSize = max;
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkClosed();
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkClosed();
        if (max < 1) {
            throw new PSQLException(GT.tr("Maximum number of rows must be a value grater than or equal to 0.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.replaceProcessingEnabled = enable;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        long seconds = this.timeout / 1000L;
        if (seconds >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)seconds;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        long millis = (long)seconds * 1000L;
        if (millis < 0L) {
            throw new PSQLException(GT.tr("Query timeout must be a value greater than or equals to 0.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.timeout = millis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws SQLException {
        AutoCloseable autoCloseable = this;
        synchronized (autoCloseable) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }
        if (this.statementState == StatementCancelState.IDLE) {
            return;
        }
        if (!STATE_UPDATER.compareAndSet(this, StatementCancelState.IN_QUERY, StatementCancelState.CANCELING)) {
            return;
        }
        autoCloseable = this.connection;
        synchronized (autoCloseable) {
            try {
                this.connection.cancelQuery();
            }
            finally {
                STATE_UPDATER.set(this, StatementCancelState.CANCELLED);
                this.connection.notifyAll();
            }
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new PSQLException(GT.tr("setCursorName is not supported.", new Object[0]), PSQLState.NOT_IMPLEMENTED);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.executeCachedSql(sql, NO_RETURNING_COLUMNS);
    }

    public boolean execute(CachedQuery cachedQuery) throws SQLException {
        this.executeInternal(cachedQuery);
        return this.resultHandler != null && this.resultHandler.getResultSet(this.maxFieldSize) != null;
    }

    public boolean execute(CachedQuery cachedQuery, ParameterList parameterList) throws SQLException {
        this.executeInternal(cachedQuery, parameterList);
        return this.resultHandler != null && this.resultHandler.getResultSet(this.maxFieldSize) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeInternal(CachedQuery cachedQuery) throws SQLException {
        Query query = cachedQuery.query;
        PbqStatementResultHandler resultHandler = new PbqStatementResultHandler(this);
        try {
            this.startTimer();
            this.connection.getExecutor().execute(query, null, resultHandler, this.maxRows);
        }
        finally {
            this.killTimerTask();
        }
        this.resultHandler = resultHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeInternal(CachedQuery cachedQuery, ParameterList parameterList) throws SQLException {
        Query query = cachedQuery.query;
        PbqStatementResultHandler resultHandler = new PbqStatementResultHandler(this);
        try {
            this.startTimer();
            this.connection.getExecutor().execute(query, parameterList, resultHandler, this.maxRows);
        }
        finally {
            this.killTimerTask();
        }
        this.resultHandler = resultHandler;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.resultHandler == null) {
            return null;
        }
        return this.resultHandler.getResultSet(this.maxFieldSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUpdateCount() throws SQLException {
        PbqStatement pbqStatement = this;
        synchronized (pbqStatement) {
            this.checkClosed();
            if (this.resultHandler == null || this.resultHandler.getResultSet(this.maxFieldSize) != null) {
                return -1;
            }
            long count = this.resultHandler.getUpdateCount();
            int n = count > Integer.MAX_VALUE ? -2 : (int)count;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLargeUpdateCount() throws SQLException {
        PbqStatement pbqStatement = this;
        synchronized (pbqStatement) {
            this.checkClosed();
            if (this.resultHandler == null || this.resultHandler.getResultSet(this.maxFieldSize) != null) {
                return -1L;
            }
            return this.resultHandler.getUpdateCount();
        }
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw new PSQLException(GT.tr("This statement has been closed.", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(3);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new PSQLException(GT.tr("setFetchDirection is not supported.", new Object[0]), PSQLState.NOT_IMPLEMENTED);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.fetchdirection;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1003;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        ArrayList<ParameterList> batchParameters;
        ArrayList<Query> batchStatements = this.batchStatements;
        if (batchStatements == null) {
            batchStatements = new ArrayList();
            this.batchStatements = batchStatements;
        }
        if ((batchParameters = this.batchParameters) == null) {
            batchParameters = new ArrayList();
            this.batchParameters = batchParameters;
        }
        boolean shouldUseParameterized = false;
        CachedQuery cachedQuery = this.connection.createQuery(sql, this.replaceProcessingEnabled, shouldUseParameterized, new String[0]);
        batchStatements.add(cachedQuery.query);
        batchParameters.add(null);
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.batchStatements != null) {
            this.batchStatements.clear();
        }
        if (this.batchParameters != null) {
            this.batchParameters.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        if (this.batchStatements == null || this.batchStatements.isEmpty()) {
            return new int[0];
        }
        Query[] queries = this.batchStatements.toArray(new Query[0]);
        ParameterList[] parameterLists = this.batchParameters.toArray(new ParameterList[0]);
        this.batchStatements.clear();
        this.batchParameters.clear();
        PbqStatementResultHandler handler = new PbqStatementResultHandler(this);
        boolean reWriteBatchedInsertsEnabled = this.connection.getExecutor().isReWriteBatchedInsertsEnabled();
        if (this.connection.isBatchInsert() && this.checkParameterList(parameterLists) && !reWriteBatchedInsertsEnabled) {
            try {
                this.startTimer();
                this.connection.getExecutor().executeBatch(queries, parameterLists, handler, this.maxRows);
            }
            finally {
                this.killTimerTask();
            }
        }
        try {
            this.startTimer();
            this.connection.getExecutor().execute(queries, parameterLists, handler, this.maxRows);
        }
        finally {
            this.killTimerTask();
        }
        return handler.getBatchUpdateCount();
    }

    public boolean checkParameterList(ParameterList[] paramlist) {
        for (int i = 0; i < paramlist.length; ++i) {
            if (paramlist[i] != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMoreResults(int current) throws SQLException {
        PbqStatement pbqStatement = this;
        synchronized (pbqStatement) {
            this.checkClosed();
            if (current == 1 && this.resultHandler != null && this.resultHandler.getResultSet(this.maxFieldSize) != null) {
                this.resultHandler.getResultSet(this.maxFieldSize).close();
            }
            if (this.resultHandler != null) {
                this.resultHandler.next();
            }
            if (current == 3 && this.resultHandler != null) {
                this.resultHandler.closeAllPrevious();
            }
            return this.resultHandler != null && this.resultHandler.getResultSet(this.maxFieldSize) != null;
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getGeneratedKeys()");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys == 2) {
            return this.executeUpdate(sql);
        }
        return this.executeUpdate(sql, (String[])null);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes == null || columnIndexes.length == 0) {
            return this.executeUpdate(sql);
        }
        throw new PSQLException(GT.tr("Returning autogenerated keys by column index is not supported.", new Object[0]), PSQLState.NOT_IMPLEMENTED);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        if (columnNames == null || columnNames.length == 0) {
            return this.executeUpdate(sql);
        }
        throw new PSQLException(GT.tr("Returning autogenerated keys by column name is not supported.", new Object[0]), PSQLState.NOT_IMPLEMENTED);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys == 2) {
            return this.execute(sql);
        }
        throw new PSQLException(GT.tr("Returning autogenerated keys is not supported.", new Object[0]), PSQLState.NOT_IMPLEMENTED);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes != null && columnIndexes.length == 0) {
            return this.execute(sql);
        }
        throw new PSQLException(GT.tr("Returning autogenerated keys by column index is not supported.", new Object[0]), PSQLState.NOT_IMPLEMENTED);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        if (columnNames != null && columnNames.length == 0) {
            return this.execute(sql);
        }
        throw new PSQLException(GT.tr("Returning autogenerated keys by column index is not supported.", new Object[0]), PSQLState.NOT_IMPLEMENTED);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.closeOnCompletion;
    }

    protected void checkCompletion() throws SQLException {
        if (!this.closeOnCompletion) {
            return;
        }
        this.closeOnCompletion = false;
        try {
            this.close();
        }
        finally {
            this.closeOnCompletion = true;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    private void startTimer() {
        this.cleanupTimer();
        STATE_UPDATER.set(this, StatementCancelState.IN_QUERY);
        if (this.timeout == 0L) {
            return;
        }
        TimerTask cancelTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    if (!CANCEL_TIMER_UPDATER.compareAndSet(PbqStatement.this, this, null)) {
                        return;
                    }
                    PbqStatement.this.cancel();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        };
        CANCEL_TIMER_UPDATER.set(this, cancelTask);
        this.connection.addTimerTask(cancelTask, this.timeout);
    }

    private boolean cleanupTimer() {
        TimerTask timerTask = CANCEL_TIMER_UPDATER.get(this);
        if (timerTask == null) {
            return this.timeout == 0L;
        }
        if (!CANCEL_TIMER_UPDATER.compareAndSet(this, timerTask, null)) {
            return false;
        }
        timerTask.cancel();
        this.connection.purgeTimerTasks();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killTimerTask() {
        boolean timerTaskIsClear = this.cleanupTimer();
        if (timerTaskIsClear && STATE_UPDATER.compareAndSet(this, StatementCancelState.IN_QUERY, StatementCancelState.IDLE)) {
            return;
        }
        boolean interrupted = false;
        PayByQueryConnection payByQueryConnection = this.connection;
        synchronized (payByQueryConnection) {
            while (!STATE_UPDATER.compareAndSet(this, StatementCancelState.CANCELLED, StatementCancelState.IDLE)) {
                try {
                    this.connection.wait(10L);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }
}

