# JDBC使用指南

---------------------------------------------------------------------------

### 获取JDBC驱动
参考资料：https://support.huaweicloud.com/mgtg-dws/dws_01_0032.html

支持的开源驱动版本

GaussDB(DWS) 也支持开源的JDBC驱动程序：PostgreSQL JDBC驱动程序9.3-1103或更高版本。

方式一

1.登录GaussDB(DWS) 管理控制台。
2.在左侧导航栏中，单击“连接管理”。
3.在“下载驱动程序”区域，选择一个驱动下载。
4.选择“DWS JDBC Driver”，然后单击“下载”可以下载与现有集群版本匹配的JDBC驱动。
5.驱动包名为“dws_8.1.x_jdbc_driver.zip”，解压后有两个JDBC的驱动jar包，
  分别为“gsjdbc4.jar”和“gsjdbc200.jar”。

说明：gsjdbc4.jar：与PostgreSQL保持兼容，其中类名、类结构与PostgreSQL驱动完全一致，
曾经运行于PostgreSQL的应用程序可以直接移植到当前系统中使用。

gsjdbc200.jar：如果同一JVM进程内需要同时访问PostgreSQL及GaussDB(DWS) 
    请使用该驱动包。该包主类名为“com.huawei.gauss200.jdbc.Driver”（即将
    “org.postgresql”替换为“com.huawei.gauss200.jdbc”） ,数据库连接的
    URL前缀为“jdbc:gaussdb”，其余与gsjdbc4.jar相同。

方式二

通过配置maven仓库的方式下载SDK包
https://mvnrepository.com/artifact/com.huaweicloud.dws/huaweicloud-dws-jdbc
复制Maven库信息，并将其添加到pom.xml文件中。例如，在pom.xml文件中添加如下代码配置：
从Maven仓库中下载的GaussDB(DWS) 驱动包版本号为8.x.x则和gsjdbc4相同，版本号为8.x.x-200与gsjdbc200.jar相同。

gsjdbc4.jar

    <dependency>
        <groupId>com.huaweicloud.dws </groupId>
        <artifactId>huaweicloud-dws-jdbc</artifactId>
        <version>8.1.0</version>
    </dependency>
    
gsjdbc200.jar

    <dependency>
        <groupId>com.huaweicloud.dws</groupId>
        <artifactId>huaweicloud-dws-jdbc</artifactId>
        <version>8.1.1.1-200</version>
    </dependency>

---------------------------------------------------------------------------

### 使用JDBC连接数据库
参考资料：https://support.huaweicloud.com/mgtg-dws/dws_01_0077.html    

前提条件

已安装JDK 1.6或以上版本，并配置环境变量。
已下载JDBC驱动，请参见下载JDBC。
GaussDB(DWS) 也支持开源的JDBC驱动程序：PostgreSQL JDBC驱动程序9.3-1103或更高版本。

#### 1.**加载驱动**
      
支持以下两种方法加载：

在代码中隐含装载：Class.forName("org.postgresql.Driver");
在JVM启动时参数传递：java -Djdbc.drivers=org.postgresql.Driver jdbctest

说明：
若使用gsjdbc200.jar，则主类名为“com.huawei.gauss200.jdbc.Driver”

#### **2.建立连接**
    
调用JDBC的数据库连接方法DriverManager.getConnection()连接GaussDB(DWS) 数据库。
JDBC接口不提供重试连接的能力，您需要在业务代码中实现重试处理。

DriverManager.getConnection()方法支持以下重载：

    DriverManager.getConnection(String url);
    DriverManager.getConnection(String url, Properties info);
    DriverManager.getConnection(String url, String user, String password);

url：数据库连接描述符，可以在管理控制台查看，具体步骤请参见获取集群连接地址。

获取集群连接地址：https://support.huaweicloud.com/mgtg-dws/dws_01_0033.html

    jdbc:postgresql:database
    jdbc:postgresql://host/database
    jdbc:postgresql://host:port/database
    jdbc:postgresql://host:port[,host:port][...]/database
说明：
    使用gsjdbc200.jar时，将“jdbc:postgresql”修改为“jdbc:gaussdb”

database为要连接的数据库名称。
    
host为数据库服务器名称或IP地址。
GaussDB(DWS)管理控制台上集群的连接IP，根据网络环境判断，如果连接GaussDB(DWS)的
机器跟GaussDB(DWS)集群在同一个网络下，则选择内网IP，不在同一个网络下，则选择公网IP。
    
port：数据库服务器端口。缺省情况下，会尝试连接到localhost的8000端口的database。
支持多ip端口配置形式，jdbc自动实现了负载均衡，多ip端口配置形式是采取随机访问+failover的方式，
这个过程系统会自动忽略不可达IP。以","隔开，
    
例如 ：

    jdbc:postgresql://10.10.0.13:8000,10.10.0.14:8000/database

### 数据库连接属性

使用JDBC连接集群时集群链接地址只支持指定jdbc连接参数，不支持增加变量参数。

常用的属性如下：

属性名 | 类型 | 描述   
---|---|---
user|String类型|表示创建连接的数据库用户。
password|String类型|表示数据库用户的密码。
ssl|Boolean类型|表示是否使用SSL连接。
prepareThreshold|integer类型|用于确定在转换为服务器端的预备语句之前，要求执行方法PreparedStatement的次数。缺省值是5。
batchMode|boolean类型|用于确定是否使用batch模式连接。
fetchsize|integer类型|用于设置数据库链接所创建statement的默认fetchsize。
ApplicationName|String类型|应用名称，在不做设置时，缺省值为PostgreSQL JDBC Driver。
allowReadOnly| boolean类型|用于设置connection是否允许设置readonly模式，默认为false，若该参数不被设置为true，则执行connection.setReadOnly不生效。
blobMode|String类型|用于设置setBinaryStream方法为不同的数据类型赋值，设置为on时表示为blob数据类型赋值，设置为off时表示为bytea数据类型赋值，默认为on。
connectionExtraInfo|Boolean类型|表示驱动是否上报当前驱动的部署路径、进程属主用户到数据库。
说明：

取值范围：true或false，默认值为true。
设置connectionExtraInfo为true，JDBC驱动会将当前驱动的部署路径、进程属主用户上报到数据库中，记录在connection_info参数里；
同时可以在PG_STAT_ACTIVITY和PGXC_STAT_ACTIVITY中查询到。

---------------------------------------------------------------------------
JDBC常见问题处理
参考：https://support.huaweicloud.com/trouble-dws/dws_09_0201.html

Check that the hostname and port are correct and that the postmaster is accepting TCP/IP connections.
    
    问题分析：可能原因为客户端与服务端网络不通、或端口错误或待连接CN异常。

    处理方法：
    客户端ping服务端IP，看网络是否畅通，网络不通则解决网络问题。
    检查URL中连接CN的端口是否正确，端口不正确修改为正确的端口（默认为8000）。

FATAL: Invalid username/password,login denied.
    
    问题分析：用户名或密码配置错误。

    处理方法：检查用户名密码是否为数据库用户名密码，将其修改为正确的数据库用户名密码。

No suitable driver found for XXXX

    问题分析：URL格式书写错误。
    
    处理方法：将URL格式修改为正确的格式。
    gsjdbc4.jar对应 jdbc:postgresql://host:port/database
    在使用pom依赖时对应8.1.x版本
    gsjdbc200.jar对应jdbc:gaussdb://host:port/database
    在使用pom依赖时对应8.1.x-200版本

在CopyManager场景使用连接池获取连接，Connection无法转换为BaseConnection
    
    问题分析：BaseConnection为非公开类，需要对连接池对象解封装然后获取原始PGConnection。
    
    处理方法： 对当前对象解包装，返回原始对象以允许访问未公开方法。

